/*
 * Decompiled with CFR 0.152.
 */
package ru.belyiz;

import java.util.Objects;

public class Counter {
    private String filesExtension;
    private long emptyLines = 0L;
    private long notEmptyLines = 0L;
    private int deprecations = 0;

    public Counter(String filesExtension) {
        if (filesExtension == null) {
            throw new IllegalArgumentException("Files extension must not be NULL");
        }
        this.filesExtension = filesExtension;
    }

    public void processLine(String line) {
        if (line.trim().isEmpty()) {
            ++this.emptyLines;
        } else {
            ++this.notEmptyLines;
            if (line.contains("@Deprecated")) {
                ++this.deprecations;
            }
        }
    }

    public void plus(Counter counter) {
        this.emptyLines += counter.emptyLines;
        this.notEmptyLines += counter.notEmptyLines;
        this.deprecations += counter.deprecations;
    }

    private long getTotalLinesCount() {
        return this.emptyLines + this.notEmptyLines;
    }

    public String toString() {
        return "Counts for files [*" + this.filesExtension + "] :\n" + this.emptyLines + " empty lines\n" + this.notEmptyLines + " not empty lines\n" + this.getTotalLinesCount() + " total lines\n" + this.deprecations + " deprecations\n";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Counter counter = (Counter)o;
        return Objects.equals(this.filesExtension, counter.filesExtension);
    }

    public int hashCode() {
        return Objects.hash(this.filesExtension);
    }
}

