/*
 * Decompiled with CFR 0.152.
 */
package ru.belyiz;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import ru.belyiz.Counter;
import ru.belyiz.FileUtils;

public class CodeLinesCounterMojo
extends AbstractMojo {
    private Map<String, Counter> fileTypes = new HashMap<String, Counter>();
    private final File sourceDirectory = new File("");
    private final String encoding = "UTF-8";

    public void execute() throws MojoExecutionException {
        if (!this.sourceDirectory.exists()) {
            this.getLog().error((CharSequence)("Source directory \"" + this.sourceDirectory + "\" is not valid."));
            return;
        }
        FileUtils.processFiles(this.sourceDirectory, file -> {
            String extension = FileUtils.getFileExtension(file);
            Counter counter = this.fileTypes.computeIfAbsent(extension, Counter::new);
            String fileAbsolutePath = file.getAbsolutePath();
            try {
                FileUtils.processFileLines(fileAbsolutePath, "UTF-8", counter::processLine);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Error while reading source file [" + fileAbsolutePath + "]"), (Throwable)e);
            }
        });
        this.writeResultsToLog();
    }

    private void writeResultsToLog() {
        Counter generalCounter = new Counter(".*");
        for (Map.Entry<String, Counter> entry : this.fileTypes.entrySet()) {
            Counter counter = entry.getValue();
            this.getLog().info((CharSequence)counter.toString());
            generalCounter.plus(counter);
        }
        if (this.fileTypes.size() > 1) {
            this.getLog().info((CharSequence)generalCounter.toString());
        }
    }
}

