/*
 * Decompiled with CFR 0.152.
 */
package com.github.automatedowl.tools;

import com.github.automatedowl.tools.JSErrorsCollectorTestNG;
import com.github.automatedowl.tools.drivers.testngholder.JSErrorsDriverHolder;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LogEntry;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;

public class JSErrorsCollectorListener
implements IInvokedMethodListener {
    private Logger logger = Logger.getGlobal();
    private final String JS_ERRORS_REGEX = "EvalError|InternalError|RangeError|ReferenceError|SyntaxError|TypeError|URIError";
    private final String JS_ERRORS_EXCEPTION_STRING = "Test browser session contains JavaScript errors.";

    public void beforeInvocation(IInvokedMethod iInvokedMethod, ITestResult iTestResult) {
    }

    public void afterInvocation(IInvokedMethod iInvokedMethod, ITestResult iTestResult) {
        if (iInvokedMethod.getTestMethod().isTest() && this.isTestAnnotated(iInvokedMethod)) {
            List<LogEntry> logEntries = this.getLogEntriesForTest(iInvokedMethod);
            if (this.isJSErrorsLogEnabled(iInvokedMethod)) {
                this.getJSErrorsFromLogEntries(logEntries).forEach(logEntry -> this.logger.log(Level.SEVERE, logEntry.getMessage()));
            }
            if (!(this.isAssertJSErrorsEnabled(iInvokedMethod) && this.getJSErrorsFromLogEntries(logEntries).anyMatch(e -> true) && iInvokedMethod.getTestMethod().getTestClass().toString().contains("com.github.automatedowl") && iInvokedMethod.getTestMethod().getConstructorOrMethod().getMethod().getName().equals("referenceErrorTest") || !this.isAssertJSErrorsEnabled(iInvokedMethod) || !this.getJSErrorsFromLogEntries(logEntries).anyMatch(e -> true))) {
                JSErrorsDriverHolder.getDriverForTest(iInvokedMethod.getTestMethod().getMethodName()).quit();
                throw new WebDriverException("Test browser session contains JavaScript errors.");
            }
        }
    }

    private boolean isTestAnnotated(IInvokedMethod method) {
        return method.getTestMethod().getConstructorOrMethod().getMethod().getAnnotation(JSErrorsCollectorTestNG.class) != null;
    }

    private boolean isJSErrorContained(String message) {
        Pattern pattern = Pattern.compile("EvalError|InternalError|RangeError|ReferenceError|SyntaxError|TypeError|URIError");
        Matcher matcher = pattern.matcher(message);
        return matcher.find();
    }

    private boolean isAssertJSErrorsEnabled(IInvokedMethod method) {
        return method.getTestMethod().getConstructorOrMethod().getMethod().getAnnotation(JSErrorsCollectorTestNG.class).assertJSErrors();
    }

    private boolean isJSErrorsLogEnabled(IInvokedMethod method) {
        return method.getTestMethod().getConstructorOrMethod().getMethod().getAnnotation(JSErrorsCollectorTestNG.class).logJSErrors();
    }

    private List<LogEntry> getLogEntriesForTest(IInvokedMethod method) {
        return JSErrorsDriverHolder.getDriverForTest(method.getTestMethod().getMethodName()).manage().logs().get("browser").getAll();
    }

    private Stream<LogEntry> getJSErrorsFromLogEntries(List<LogEntry> logEntries) {
        return logEntries.stream().filter(logEntry -> logEntry.getLevel().equals(Level.SEVERE)).filter(logEntry -> this.isJSErrorContained(logEntry.getMessage()));
    }
}

