package com.github.automatedowl.tools.pages;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.AjaxElementLocatorFactory;

public class Site88Page {

    /** Default timeout of waiting for web elements in the page. */
    private static final int DEFAULT_ELEMENT_TIMEOUT = 30;
    private static final String SITE88_URL = "http://testjs.site88.net";

    /////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////// Constructor /////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////

    public Site88Page(WebDriver driver) {
        PageFactory.initElements(
                new AjaxElementLocatorFactory(
                        driver, DEFAULT_ELEMENT_TIMEOUT), this);
    }

    /////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////// Web Elements ////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////

    /** Define the web element of test button. */
    @FindBy(name = "testClickButton")
    private WebElement testButton;

    /////////////////////////////////////////////////////////////////////////////////
    /////////////////////////////// Getters /////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////

    public WebElement getTestButton() {
        return testButton;
    }

    /////////////////////////////////////////////////////////////////////////////////
    ///////////////////////// Public Methods ////////////////////////////////////////
    /////////////////////////////////////////////////////////////////////////////////

    public void navigateToPage(WebDriver driver) {
        driver.get(SITE88_URL);
    }
}