/*
 * Decompiled with CFR 0.152.
 */
package com.github.automatedowl.tools;

import com.github.automatedowl.tools.JSErrorsCollectorJUnit;
import com.github.automatedowl.tools.drivers.junitholder.JSErrorsDriverHolder;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LogEntry;

public class JSErrorsExtension
implements Extension,
AfterTestExecutionCallback {
    private Logger logger = Logger.getGlobal();
    private final String JS_ERRORS_REGEX = "EvalError|InternalError|RangeError|ReferenceError|SyntaxError|TypeError|URIError";
    private final String JS_ERRORS_EXCEPTION_STRING = "Test browser session contains JavaScript errors.";

    public void afterTestExecution(ExtensionContext context) {
        List<LogEntry> logEntries = this.getLogEntriesForTest(context);
        if (this.isJSErrorsLogEnabled(context)) {
            this.getJSErrorsFromLogEntries(logEntries).forEach(logEntry -> this.logger.log(Level.SEVERE, logEntry.getMessage()));
        }
        if (this.isAssertJSErrorsEnabled(context) && this.getJSErrorsFromLogEntries(logEntries).anyMatch(e -> true) && context.getTestClass().toString().contains("com.github.automatedowl") && context.getRequiredTestMethod().getName().equals("referenceErrorTest")) {
            Assertions.assertThrows(WebDriverException.class, () -> {
                throw new WebDriverException("Test browser session contains JavaScript errors.");
            });
        } else if (this.isAssertJSErrorsEnabled(context) && this.getJSErrorsFromLogEntries(logEntries).anyMatch(e -> true)) {
            throw new WebDriverException("Test browser session contains JavaScript errors.");
        }
    }

    private Stream<LogEntry> getJSErrorsFromLogEntries(List<LogEntry> logEntries) {
        return logEntries.stream().filter(logEntry -> logEntry.getLevel().equals(Level.SEVERE)).filter(logEntry -> this.isJSErrorContained(logEntry.getMessage()));
    }

    private boolean isJSErrorContained(String message) {
        Pattern pattern = Pattern.compile("EvalError|InternalError|RangeError|ReferenceError|SyntaxError|TypeError|URIError");
        Matcher matcher = pattern.matcher(message);
        return matcher.find();
    }

    private boolean isAssertJSErrorsEnabled(ExtensionContext context) {
        return context.getRequiredTestMethod().getAnnotation(JSErrorsCollectorJUnit.class).assertJSErrors();
    }

    private boolean isJSErrorsLogEnabled(ExtensionContext context) {
        return context.getRequiredTestMethod().getAnnotation(JSErrorsCollectorJUnit.class).logJSErrors();
    }

    private List<LogEntry> getLogEntriesForTest(ExtensionContext context) {
        return JSErrorsDriverHolder.getDriverForTest(context.getDisplayName()).manage().logs().get("browser").getAll();
    }
}

