/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.utility;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.IRef;
import cn.org.atool.fluent.mybatis.base.crud.BaseFormSetter;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.model.ISqlOp;
import cn.org.atool.fluent.mybatis.base.model.SqlOp;
import cn.org.atool.fluent.mybatis.base.model.op.SqlOps;
import cn.org.atool.fluent.mybatis.functions.FormApply;
import cn.org.atool.fluent.mybatis.model.Form;
import cn.org.atool.fluent.mybatis.model.FormItem;
import cn.org.atool.fluent.mybatis.model.IFormApply;
import cn.org.atool.fluent.mybatis.segment.WhereBase;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.PoJoHelper;
import java.util.Map;
import java.util.function.Supplier;

public class FormHelper {
    public static <E extends IEntity> IQuery toQuery(Class<E> entityClass, Form form) {
        MybatisUtil.assertNotNull("entityClass", entityClass);
        if (form.getNextId() != null && form.getCurrPage() != null) {
            throw new RuntimeException("nextId and currPage can only have one value");
        }
        IQuery query = IRef.instance().query(entityClass);
        WhereBase where = query.where();
        block10: for (FormItem item : form.getItems()) {
            String column = IRef.instance().columnOfField(entityClass, item.getKey());
            if (If.isBlank(column)) {
                throw new RuntimeException("the field[" + item.getKey() + "] of Entity[" + entityClass.getSimpleName() + "] not found.");
            }
            switch (item.getOp()) {
                case "LEFT_LIKE": {
                    ((WhereBase)where.and).apply(column, (ISqlOp)SqlOp.LIKE, item.getValue()[0] + "%");
                    continue block10;
                }
                case "LIKE": {
                    ((WhereBase)where.and).apply(column, (ISqlOp)SqlOp.LIKE, "%" + item.getValue()[0] + "%");
                    continue block10;
                }
                case "NOT_LIKE": {
                    ((WhereBase)where.and).apply(column, (ISqlOp)SqlOp.NOT_LIKE, "%" + item.getValue()[0] + "%");
                    continue block10;
                }
            }
            ((WhereBase)where.and).apply(column, SqlOps.get(item.getOp()), item.getValue());
        }
        if (form.getCurrPage() != null) {
            int from = form.getPageSize() * (form.getCurrPage() - 1);
            query.limit(from, form.getPageSize());
        } else if (form.getNextId() != null) {
            String column = IRef.instance().primaryColumn(entityClass);
            ((WhereBase)where.and).apply(column, (ISqlOp)SqlOp.GE, form.getNextId());
            query.limit(form.getPageSize());
        }
        return query;
    }

    public static <E extends IEntity, S extends BaseFormSetter> IFormApply<E, S> by(Object object, Form form, Supplier<S> setterSupplier) {
        MybatisUtil.assertNotNull("object", object);
        Map map = PoJoHelper.toMap(object);
        return new FormApply((BaseFormSetter)setterSupplier.get(), map, form);
    }
}

