/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.spring;

import cn.org.atool.fluent.mybatis.base.IRef;
import cn.org.atool.fluent.mybatis.base.mapper.IEntityMapper;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class MapperFactory {
    private ApplicationContext context;

    @Autowired
    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public <T extends IEntityMapper> T getBean(Class<T> mapperInterface) {
        return (T)((IEntityMapper)this.context.getBean(mapperInterface));
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        IRef refs = IRef.instance();
        Object relation = this.findEntityRelation();
        refs.setEntityRelation(relation, this);
        refs.wiredMapper();
    }

    private Object findEntityRelation() throws ClassNotFoundException {
        try {
            Class<?> klass = Class.forName("cn.org.atool.fluent.mybatis.refs.IEntityRelation");
            return this.context.getBean(klass);
        }
        catch (NoSuchBeanDefinitionException be) {
            return null;
        }
    }
}

