/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment.model;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.segment.BaseSegmentList;
import cn.org.atool.fluent.mybatis.segment.GroupBySegmentList;
import cn.org.atool.fluent.mybatis.segment.HavingSegmentList;
import cn.org.atool.fluent.mybatis.segment.OrderBySegmentList;
import cn.org.atool.fluent.mybatis.segment.WhereSegmentList;
import cn.org.atool.fluent.mybatis.segment.model.ISqlSegment;
import cn.org.atool.fluent.mybatis.segment.model.KeyWordSegment;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;

public class MergeSegments
extends BaseSegmentList {
    private final WhereSegmentList where = new WhereSegmentList();
    private final GroupBySegmentList groupBy = new GroupBySegmentList();
    private final HavingSegmentList having = new HavingSegmentList();
    private final OrderBySegmentList orderBy = new OrderBySegmentList();
    private String lastSql = "";

    public MergeSegments setLastSql(String lastSql) {
        this.lastSql = If.isBlank(this.lastSql) ? lastSql : this.lastSql + " " + lastSql;
        return this;
    }

    @Override
    public MergeSegments add(ISqlSegment first, ISqlSegment ... segments) {
        if (first == null) {
            return this;
        }
        if (KeyWordSegment.ORDER_BY == first) {
            this.orderBy.add(first, segments);
        } else if (KeyWordSegment.GROUP_BY == first) {
            this.groupBy.add(first, segments);
        } else if (KeyWordSegment.HAVING == first) {
            this.having.add(first, segments);
        } else {
            this.where.add(first, segments);
        }
        this.cache = null;
        return this;
    }

    @Override
    protected String build() {
        String sql = this.where.sql() + this.groupBy.sql() + this.having.sql() + this.orderBy.sql();
        return sql.trim() + this.last();
    }

    public String last() {
        return If.isBlank(this.lastSql) ? "" : " " + this.lastSql.trim();
    }

    public String whereSql() {
        return MybatisUtil.trim(this.where.sql());
    }

    public String groupBy() {
        return MybatisUtil.trim(this.groupBy.sql() + this.having.sql());
    }

    public String orderBy() {
        return MybatisUtil.trim(this.orderBy.sql());
    }

    public WhereSegmentList getWhere() {
        return this.where;
    }

    public GroupBySegmentList getGroupBy() {
        return this.groupBy;
    }

    public HavingSegmentList getHaving() {
        return this.having;
    }

    public OrderBySegmentList getOrderBy() {
        return this.orderBy;
    }

    public String getLastSql() {
        return this.lastSql;
    }
}

