/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.crud.IBaseQuery;
import cn.org.atool.fluent.mybatis.base.model.Column;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.functions.FieldPredicate;
import cn.org.atool.fluent.mybatis.functions.IAggregate;
import cn.org.atool.fluent.mybatis.segment.AggregateSegment;
import java.util.List;
import java.util.stream.Stream;

public abstract class SelectorBase<S extends SelectorBase<S, Q>, Q extends IBaseQuery<?, Q>>
extends AggregateSegment<S, Q, S> {
    private static final String AS = " AS ";

    protected SelectorBase(Q query) {
        super(query);
    }

    protected SelectorBase(S origin, IAggregate aggregate) {
        super(origin, aggregate);
    }

    public S apply(String column, String ... columns) {
        if (If.notEmpty(columns) && this.aggregate != null) {
            throw new RuntimeException("Aggregate functions allow only one column.");
        }
        this.applyAs(column, null);
        Stream.of(columns).forEach(c -> this.applyAs((String)c, null));
        return (S)((SelectorBase)super.getOrigin());
    }

    public S apply(FieldMapping ... columns) {
        if (If.isEmpty(columns)) {
            throw new RuntimeException("Apply column missing.");
        }
        if (this.aggregate != null && columns.length > 1) {
            throw new RuntimeException("Aggregate functions allow only one column.");
        }
        for (FieldMapping column : columns) {
            Column _column = Column.column(column, this.wrapper);
            this.selectColumn(_column, null);
        }
        return (S)((SelectorBase)super.getOrigin());
    }

    public S applyAs(FieldMapping field, String alias) {
        Column column = Column.column(field, this.wrapper);
        this.selectColumn(column, alias);
        return (S)((SelectorBase)super.getOrigin());
    }

    public S applyAs(String column, String alias) {
        Column _column = Column.column(column, this.wrapper);
        this.selectColumn(_column, alias);
        return (S)((SelectorBase)super.getOrigin());
    }

    private void selectColumn(Column column, String alias) {
        String wrapper = column.wrapColumn();
        if (this.aggregate != null) {
            wrapper = this.aggregate.aggregate(wrapper);
        }
        if (If.notBlank(alias)) {
            wrapper = wrapper + AS + alias;
        }
        this.wrapperData().addSelectColumn(wrapper);
    }

    public S count(String alias) {
        return this.applyAs("count(*)", alias);
    }

    public S apply(FieldPredicate predicate) {
        List<String> columns = this.wrapper.getTableMeta().filter(false, predicate);
        columns.forEach(x$0 -> this.apply((String)x$0, new String[0]));
        return (S)((SelectorBase)super.getOrigin());
    }

    @Override
    protected S apply() {
        return this.applyAs(this.current.column, null);
    }

    protected S process(FieldMapping field, String alias) {
        this.current = field;
        return this.applyAs(field, alias);
    }
}

