/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.IRef;
import cn.org.atool.fluent.mybatis.base.crud.BaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.splice.FreeQuery;
import cn.org.atool.fluent.mybatis.functions.IGetter;
import cn.org.atool.fluent.mybatis.metadata.JoinType;
import cn.org.atool.fluent.mybatis.segment.BaseSegment;
import cn.org.atool.fluent.mybatis.segment.JoinOnBuilder;
import cn.org.atool.fluent.mybatis.segment.JoinQuery;
import cn.org.atool.fluent.mybatis.segment.model.Parameters;
import cn.org.atool.fluent.mybatis.segment.where.BaseWhere;
import cn.org.atool.fluent.mybatis.utility.MappingKits;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.util.function.Function;

public class JoinOn<QL extends BaseQuery<?, QL>, QR extends BaseQuery<?, QR>, JB> {
    private final JoinQuery<QL> joinQuery;
    private final QL onLeft;
    private final QR onRight;
    private final JoinOnBuilder<QL, QR> onBuilder;

    public JoinOn(JoinQuery<QL> joinQuery, QL qLeft, JoinType joinType, QR qRight) {
        this.joinQuery = joinQuery;
        this.onBuilder = new JoinOnBuilder(qLeft, joinType, qRight);
        this.onLeft = this.emptyQuery((BaseQuery)qLeft);
        this.onRight = this.emptyQuery((BaseQuery)qRight);
    }

    private <Q extends BaseQuery> Q emptyQuery(BaseQuery origQuery) {
        BaseQuery onQuery;
        if (origQuery instanceof FreeQuery) {
            onQuery = ((FreeQuery)origQuery).emptyQuery();
            ((FreeQuery)onQuery).setDbType(origQuery.dbType());
        } else {
            onQuery = (BaseQuery)IRef.instance().mapping(origQuery.entityClass).emptyQuery();
        }
        onQuery.tableAlias = origQuery.tableAlias;
        onQuery.sharedParameter(this.joinQuery);
        return (Q)onQuery;
    }

    public JoinOn<QL, QR, JB> onApply(String condition, Object ... args) {
        String sql = Parameters.parseSql(this.joinQuery, condition, args);
        this.onBuilder.on(sql);
        return this;
    }

    public JoinOn<QL, QR, JB> on(Function<QL, BaseWhere> l, Function<QR, BaseWhere> r) {
        this.onBuilder.on(l.apply(this.onLeft), r.apply(this.onRight));
        return this;
    }

    public <LE extends IEntity, RE extends IEntity> JoinOn<QL, QR, JB> onEq(IGetter<LE> l, IGetter<RE> r) {
        Class lKlass = ((BaseQuery)this.onLeft).wrapperData.getEntityClass();
        Class rKlass = ((BaseQuery)this.onRight).wrapperData.getEntityClass();
        MybatisUtil.assertNotNull("left query entity class", lKlass);
        MybatisUtil.assertNotNull("right query entity class", rKlass);
        String lField = MappingKits.toColumn(lKlass, l);
        String rField = MappingKits.toColumn(rKlass, r);
        return this.onEq(lField, rField);
    }

    public JoinOn<QL, QR, JB> onEq(String l, String r) {
        this.onBuilder.on(l, r);
        return this;
    }

    public JoinOn<QL, QR, JB> onEq(FieldMapping l, FieldMapping r) {
        this.onBuilder.on(l.column, r.column);
        return this;
    }

    public JoinOn<QL, QR, JB> onLeft(Function<QL, BaseSegment<?, QL>> l) {
        return this.onQuery((IQuery)this.onLeft, l);
    }

    public JoinOn<QL, QR, JB> onRight(Function<QR, BaseSegment<?, QR>> r) {
        return this.onQuery((IQuery)this.onRight, r);
    }

    private JoinOn onQuery(IQuery query, Function func) {
        Object onQuery = this.emptyQuery((BaseQuery)query);
        String sql = ((BaseSegment)func.apply(onQuery)).end().getWrapperData().getWhereSql();
        this.onBuilder.on(sql);
        return this;
    }

    public JB endJoin() {
        this.joinQuery.getWrapperData().addTable(this.onBuilder.table());
        return (JB)this.joinQuery;
    }
}

