/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.IHasDbType;
import cn.org.atool.fluent.mybatis.base.crud.IBaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.model.Column;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.model.UniqueFieldType;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.metadata.TableMeta;
import cn.org.atool.fluent.mybatis.metadata.TableMetaHelper;
import cn.org.atool.fluent.mybatis.segment.model.Parameters;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public abstract class BaseWrapper<E extends IEntity, W extends IWrapper<E, W, NQ>, NQ extends IBaseQuery<E, NQ>>
implements IWrapper<E, W, NQ>,
IHasDbType {
    private static final long serialVersionUID = 2674302532927710150L;
    protected Supplier<String> table;
    protected String tableAlias;
    protected WrapperData wrapperData;
    protected Class entityClass;

    protected BaseWrapper(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    protected BaseWrapper(Supplier<String> table, String tableAlias, Class<E> entityClass, Class queryClass) {
        this(table, tableAlias, new Parameters(), entityClass, queryClass);
        this.entityClass = entityClass;
    }

    protected BaseWrapper(Supplier<String> table, String tableAlias, Parameters parameters, Class<E> entityClass, Class queryClass) {
        MybatisUtil.notNull(entityClass, "entityClass must not null,please set entity before use this method!", new Object[0]);
        this.table = table;
        this.tableAlias = If.isBlank(tableAlias) ? "" : tableAlias.trim();
        this.wrapperData = new WrapperData(table, this.tableAlias, parameters, entityClass, queryClass);
        this.entityClass = entityClass;
    }

    protected Optional<IMapping> mapping() {
        return Optional.empty();
    }

    public String fieldName(UniqueFieldType type) {
        return this.mapping().flatMap(m -> m.findField(type)).map(c -> c.column).orElse(null);
    }

    protected List<String> allFields() {
        return this.mapping().map(IMapping::getAllColumns).orElse(Collections.emptyList());
    }

    protected TableMeta getTableMeta() {
        return TableMetaHelper.getTableInfo(this.getWrapperData().getEntityClass());
    }

    protected String appendAlias(String column) {
        return Column.column(column, this).wrapColumn();
    }

    protected void sharedParameter(Parameters parameters) {
        this.wrapperData.getParameters().sharedParameter(parameters);
    }

    protected void sharedParameter(BaseWrapper wrapper) {
        this.wrapperData.getParameters().sharedParameter(wrapper.getWrapperData().getParameters());
    }

    public FieldMapping column(String column) {
        return this.column2mapping().get(column);
    }

    @Override
    public DbType dbType() {
        return this.mapping().map(IMapping::getDbType).orElseThrow(() -> new RuntimeException("DbType is not set."));
    }

    private Map<String, FieldMapping> column2mapping() {
        return this.mapping().map(IMapping::getColumnMap).orElse(Collections.EMPTY_MAP);
    }

    public Supplier<String> getTable() {
        return this.table;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public WrapperData getWrapperData() {
        return this.wrapperData;
    }
}

