/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.segment.model.ISqlSegment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public abstract class BaseSegmentList {
    protected final List<ISqlSegment> segments = new ArrayList<ISqlSegment>();
    protected String cache = null;

    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    public abstract BaseSegmentList add(ISqlSegment var1, ISqlSegment ... var2);

    protected final BaseSegmentList addAll(ISqlSegment ... sqlSegments) {
        this.segments.addAll(Arrays.asList(sqlSegments));
        this.cache = null;
        return this;
    }

    public final String sql() {
        if (this.cache == null) {
            this.cache = this.build();
        }
        return this.cache;
    }

    protected abstract String build();

    protected String merge(String prefix, String delimiter) {
        if (this.segments.isEmpty()) {
            return "";
        }
        return this.segments.stream().map(ISqlSegment::getSqlSegment).filter(sql -> !sql.isEmpty()).collect(Collectors.joining(delimiter, prefix, ""));
    }

    public List<ISqlSegment> getSegments() {
        return this.segments;
    }
}

