/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.model;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.BaseFormSetter;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.model.op.SqlOps;
import cn.org.atool.fluent.mybatis.model.IFormQuery;
import cn.org.atool.fluent.mybatis.segment.WhereBase;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import java.util.Map;
import lombok.NonNull;

public class FormQuery<E extends IEntity, S extends BaseFormSetter>
implements IFormQuery<E, S> {
    private final Class<? extends IEntity> entityClazz;
    private final Map<String, Object> form;
    private final IQuery query;
    private final BaseFormSetter setter;

    public FormQuery(@NonNull IEntity entity, @NonNull IQuery query, @NonNull S setter) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (setter == null) {
            throw new NullPointerException("setter is marked non-null but is null");
        }
        this.form = entity.toEntityMap();
        this.query = query;
        this.setter = setter;
        this.entityClazz = ((BaseFormSetter)setter).entityClass();
    }

    public FormQuery(@NonNull IQuery query, @NonNull Map form, @NonNull S setter) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (form == null) {
            throw new NullPointerException("form is marked non-null but is null");
        }
        if (setter == null) {
            throw new NullPointerException("setter is marked non-null but is null");
        }
        this.form = form;
        this.query = query;
        this.setter = setter;
        this.entityClazz = ((BaseFormSetter)setter).entityClass();
    }

    @Override
    public Class<? extends IEntity> entityClass() {
        return this.entityClazz;
    }

    @Override
    public S op(String op) {
        this.setter.set(c -> this.query.where().apply(c.column, SqlOps.get(op), this.form.get(c.name)));
        return (S)this.setter;
    }

    @Override
    public IFormQuery<E, S> distinct() {
        this.query.distinct();
        return this;
    }

    @Override
    public IFormQuery<E, S> selectAll() {
        this.query.selectAll();
        return this;
    }

    @Override
    public IFormQuery<E, S> selectId() {
        this.query.selectId();
        return this;
    }

    @Override
    public IFormQuery<E, S> limit(int limit) {
        this.query.limit(limit);
        return this;
    }

    @Override
    public IFormQuery<E, S> limit(int start, int limit) {
        this.query.limit(start, limit);
        return this;
    }

    @Override
    public IFormQuery<E, S> last(String lastSql) {
        this.query.last(lastSql);
        return this;
    }

    @Override
    public WhereBase where() {
        return this.query.where();
    }

    @Override
    public WrapperData getWrapperData() {
        return this.query.getWrapperData();
    }
}

