/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.provider;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.IHasDbType;
import cn.org.atool.fluent.mybatis.base.crud.BaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.BatchCrudImpl;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.provider.SqlKit;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.segment.BaseWrapper;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.SqlProviderKit;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class SqlProvider<E extends IEntity>
implements IHasDbType {
    private final SqlKit sqlKit = SqlKit.factory(this);

    public static String batchCrud(Map map) {
        IWrapper wrapper = SqlProviderKit.getWrapper(map, "ew");
        if (!(wrapper instanceof BatchCrudImpl)) {
            throw new IllegalArgumentException("the wrapper should be an instance of BatchUpdaterImpl.");
        }
        BatchCrudImpl crud = (BatchCrudImpl)wrapper;
        return SqlKit.factory(crud).batchCrud(crud);
    }

    public String insertSelect(Map map) {
        String[] fields = (String[])map.get("fields");
        BaseQuery query = (BaseQuery)map.get("ew");
        String table = this.dynamic(query);
        return this.sqlKit.insertSelect(table, fields, query);
    }

    public String insert(E entity) {
        MybatisUtil.assertNotNull("entity", entity);
        return this.sqlKit.insertEntity(this, "", entity, false);
    }

    public String insertWithPk(E entity) {
        MybatisUtil.assertNotNull("entity", entity);
        return this.sqlKit.insertEntity(this, "", entity, true);
    }

    public String insertBatch(Map map) {
        MybatisUtil.assertNotEmpty("list", map);
        List entities = (List)SqlProviderKit.getParas(map, "list");
        return this.sqlKit.insertBatch(this, entities, false);
    }

    public String insertBatchWithPk(Map map) {
        MybatisUtil.assertNotEmpty("list", map);
        List entities = (List)SqlProviderKit.getParas(map, "list");
        return this.sqlKit.insertBatch(this, entities, true);
    }

    public String updateById(Map<String, Object> map) {
        IEntity entity = (IEntity)SqlProviderKit.getParas(map, "et");
        MybatisUtil.assertNotNull("entity", entity);
        return this.sqlKit.updateById(this, entity);
    }

    public String countNoLimit(Map map) {
        WrapperData ew = SqlProviderKit.getWrapperData(map, "ew");
        return this.sqlKit.countNoLimit(this, ew);
    }

    public String count(Map map) {
        WrapperData ew = SqlProviderKit.getWrapperData(map, "ew");
        return this.sqlKit.count(this, ew);
    }

    public String listEntity(Map map) {
        WrapperData ew = SqlProviderKit.getWrapperData(map, "ew");
        return this.sqlKit.queryByQuery(this, ew);
    }

    public String listMaps(Map map) {
        WrapperData ew = SqlProviderKit.getWrapperData(map, "ew");
        return this.sqlKit.queryByQuery(this, ew);
    }

    public String listObjs(Map map) {
        WrapperData ew = SqlProviderKit.getWrapperData(map, "ew");
        return this.sqlKit.queryByQuery(this, ew);
    }

    public String listByMap(Map map) {
        Map where = (Map)SqlProviderKit.getParas(map, "cm");
        MybatisUtil.assertNotEmpty("where", where);
        return this.sqlKit.queryByMap(this, where);
    }

    public String listByIds(Map map) {
        Collection ids = (Collection)SqlProviderKit.getParas(map, "list");
        MybatisUtil.assertNotEmpty("PrimaryKeyList", ids);
        return this.sqlKit.queryByIds(this, ids);
    }

    public String findById(Serializable id) {
        MybatisUtil.assertNotNull("PrimaryKey", id);
        return this.sqlKit.queryById(this, id);
    }

    public String findOne(Map map) {
        WrapperData ew = SqlProviderKit.getWrapperData(map, "ew");
        return this.sqlKit.queryByQuery(this, ew);
    }

    public String deleteById(Map map) {
        Object[] ids = (Serializable[])map.get("list");
        MybatisUtil.assertNotEmpty("ids", ids);
        return this.sqlKit.deleteById(this, (Serializable[])ids);
    }

    public String logicDeleteById(Map map) {
        Object[] ids = (Serializable[])map.get("list");
        MybatisUtil.assertNotEmpty("ids", ids);
        return this.sqlKit.logicDeleteById(this, (Serializable[])ids);
    }

    public String deleteByIds(Map map) {
        Collection ids = (Collection)SqlProviderKit.getParas(map, "list");
        MybatisUtil.assertNotEmpty("ids", ids);
        return this.sqlKit.deleteByIds(this, ids);
    }

    public String logicDeleteByIds(Map map) {
        Collection ids = (Collection)SqlProviderKit.getParas(map, "list");
        MybatisUtil.assertNotEmpty("ids", ids);
        return this.sqlKit.logicDeleteByIds(this, ids);
    }

    public String deleteByMap(Map<String, Object> map) {
        Map cm = (Map)SqlProviderKit.getParas(map, "cm");
        return this.sqlKit.deleteByMap(this, cm);
    }

    public String logicDeleteByMap(Map<String, Object> map) {
        Map cm = (Map)SqlProviderKit.getParas(map, "cm");
        return this.sqlKit.logicDeleteByMap(this, cm);
    }

    public String delete(Map map) {
        WrapperData ew = SqlProviderKit.getWrapperData(map, "ew");
        return this.sqlKit.deleteBy(this, ew);
    }

    public String logicDelete(Map map) {
        WrapperData ew = SqlProviderKit.getWrapperData(map, "ew");
        return this.sqlKit.logicDeleteBy(this, ew);
    }

    public String updateBy(Map<String, Object> map) {
        Object wrapper = map.get("ew");
        if (If.isEmpty(wrapper)) {
            throw FluentMybatisException.instance("the parameter[%s] can't be empty.", "ew");
        }
        if (!(wrapper instanceof IUpdate[])) {
            throw new IllegalArgumentException("the parameter should be an array of IUpdate");
        }
        return this.sqlKit.updateBy(this, (IUpdate[])wrapper);
    }

    public void setEntityByDefault(IEntity entity) {
        this.mapping().defaultSetter().setInsertDefault(entity);
    }

    @Override
    public DbType dbType() {
        return this.mapping().getDbType();
    }

    public String tableName() {
        return this.mapping().getTableName();
    }

    public abstract IMapping mapping();

    private String dynamic(IWrapper wrapper) {
        String table = ((BaseWrapper)wrapper).getTable().get();
        return If.isBlank(table) ? this.tableName() : table;
    }
}

