/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.provider;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.IHasDbType;
import cn.org.atool.fluent.mybatis.base.crud.BatchCrudImpl;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.provider.CommonSqlKit;
import cn.org.atool.fluent.mybatis.base.provider.OracleSqlKit;
import cn.org.atool.fluent.mybatis.base.provider.SqlProvider;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface SqlKit {
    public static final Map<DbType, SqlKit> kits = new HashMap<DbType, SqlKit>(8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlKit factory(DbType dbType) {
        SqlKit kit = kits.get(dbType);
        if (kit == null) {
            Map<DbType, SqlKit> map = kits;
            synchronized (map) {
                if (kits.containsKey(dbType)) {
                    return kits.get(dbType);
                }
                switch (dbType) {
                    case ORACLE: 
                    case ORACLE12: {
                        kits.put(dbType, new OracleSqlKit(dbType));
                        break;
                    }
                    default: {
                        kits.put(dbType, new CommonSqlKit(dbType));
                    }
                }
                return kits.get(dbType);
            }
        }
        return kit;
    }

    public static SqlKit factory(IHasDbType hasDbType) {
        return SqlKit.factory(hasDbType.dbType());
    }

    default public String batchCrud(BatchCrudImpl crud) {
        return crud.batchSql();
    }

    public <E extends IEntity> String insertEntity(SqlProvider var1, String var2, E var3, boolean var4);

    public String insertSelect(String var1, String[] var2, IQuery var3);

    public <E extends IEntity> String insertBatch(SqlProvider var1, List<E> var2, boolean var3);

    public String deleteById(SqlProvider var1, Serializable[] var2);

    public String deleteByIds(SqlProvider var1, Collection var2);

    public String logicDeleteById(SqlProvider var1, Serializable[] var2);

    public String logicDeleteByIds(SqlProvider var1, Collection var2);

    public String deleteByMap(SqlProvider var1, Map<String, Object> var2);

    public String logicDeleteByMap(SqlProvider var1, Map<String, Object> var2);

    public String deleteBy(SqlProvider var1, WrapperData var2);

    public String logicDeleteBy(SqlProvider var1, WrapperData var2);

    public String updateBy(SqlProvider var1, IUpdate[] var2);

    public String updateBy(SqlProvider var1, WrapperData var2);

    public String updateById(SqlProvider var1, IEntity var2);

    public String countNoLimit(SqlProvider var1, WrapperData var2);

    public String count(SqlProvider var1, WrapperData var2);

    public String queryByQuery(SqlProvider var1, WrapperData var2);

    public String queryByMap(SqlProvider var1, Map var2);

    public String queryByIds(SqlProvider var1, Collection var2);

    public String queryById(SqlProvider var1, Serializable var2);
}

