/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.provider;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.BatchCrudImpl;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.model.InsertList;
import cn.org.atool.fluent.mybatis.base.provider.CommonSqlKit;
import cn.org.atool.fluent.mybatis.base.provider.SqlProvider;
import cn.org.atool.fluent.mybatis.mapper.MapperSql;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OracleSqlKit
extends CommonSqlKit {
    static final Map<String, String> SEQs = new HashMap<String, String>();

    public OracleSqlKit(DbType dbType) {
        super(dbType);
    }

    @Override
    public String batchCrud(BatchCrudImpl crud) {
        String sql = crud.batchSql();
        return OracleSqlKit.wrapperBeginEnd(sql);
    }

    @Override
    public <E extends IEntity> String insertEntity(SqlProvider provider, String prefix, E entity, boolean withPk) {
        withPk = If.notBlank(this.dbType.feature.getSeq());
        return super.insertEntity(provider, prefix, entity, withPk);
    }

    @Override
    public <E extends IEntity> String insertBatch(SqlProvider provider, List<E> entities, boolean withPk) {
        MapperSql sql = new MapperSql();
        List<Map> maps = this.toMaps(provider, entities, withPk);
        String tableName = OracleSqlKit.dynamic((IEntity)entities.get(0), provider.tableName());
        List<FieldMapping> nonFields = this.nonFields(provider, maps, withPk);
        sql.INSERT_INTO(tableName == null ? provider.tableName() : tableName);
        sql.INSERT_COLUMNS(provider.dbType(), nonFields.stream().map(f -> f.column).collect(Collectors.toList()));
        sql.APPEND("SELECT");
        if (!withPk) {
            sql.APPEND(OracleSqlKit.getSeq(this.dbType.feature.getSeq()) + ",");
        }
        sql.APPEND("TMP.* FROM (");
        for (int index = 0; index < maps.size(); ++index) {
            if (index > 0) {
                sql.APPEND("UNION ALL");
            }
            sql.APPEND("SELECT");
            boolean first = true;
            for (FieldMapping f2 : nonFields) {
                if (!first) {
                    sql.APPEND(", ");
                } else {
                    first = false;
                }
                sql.APPEND(InsertList.el("list[" + index + "].", f2, maps.get(index).get(f2.column), f2.insert));
            }
            sql.APPEND(" FROM dual");
        }
        sql.APPEND(") TMP");
        return sql.toString();
    }

    @Override
    public String updateBy(SqlProvider provider, IUpdate[] updaters) {
        String sql = super.updateBy(provider, updaters);
        return updaters.length == 1 ? sql : OracleSqlKit.wrapperBeginEnd(sql);
    }

    public static String wrapperBeginEnd(String sql) {
        return "BEGIN " + sql + "; END;";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSeq(String seq) {
        if (If.isBlank(seq)) {
            return "SEQ_USER_ID.nextval";
        }
        if (!SEQs.containsKey(seq)) {
            Map<String, String> map = SEQs;
            synchronized (map) {
                String upper = seq.toUpperCase().trim();
                int index = upper.indexOf("FROM");
                if (index > 0 && upper.startsWith("SELECT") && upper.endsWith("DUAL")) {
                    SEQs.put(seq, seq.substring(6, index).trim());
                } else {
                    SEQs.put(seq, seq);
                }
            }
        }
        return SEQs.get(seq);
    }
}

