/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.provider;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.BaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.entity.IRichEntity;
import cn.org.atool.fluent.mybatis.base.entity.PkGeneratorKits;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.model.InsertList;
import cn.org.atool.fluent.mybatis.base.model.UpdateDefault;
import cn.org.atool.fluent.mybatis.base.model.UpdateSet;
import cn.org.atool.fluent.mybatis.base.provider.SqlKit;
import cn.org.atool.fluent.mybatis.base.provider.SqlProvider;
import cn.org.atool.fluent.mybatis.mapper.MapperSql;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.SqlProviderKit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CommonSqlKit
implements SqlKit {
    protected final DbType dbType;

    public CommonSqlKit(DbType dbType) {
        this.dbType = dbType;
    }

    @Override
    public <E extends IEntity> String insertEntity(SqlProvider provider, String prefix, E entity, boolean withPk) {
        MybatisUtil.assertNotNull("entity", entity);
        withPk = this.validateInsertEntity(entity, withPk, provider::setEntityByDefault);
        MapperSql sql = new MapperSql();
        sql.INSERT_INTO(CommonSqlKit.dynamic(entity, provider.tableName()));
        InsertList inserts = this.insertColumns(provider, prefix, entity, withPk);
        sql.INSERT_COLUMNS(this.dbType, inserts.columns);
        sql.VALUES();
        sql.INSERT_VALUES(inserts.values);
        return sql.toString();
    }

    private InsertList insertColumns(SqlProvider provider, String prefix, IEntity entity, boolean withPk) {
        InsertList inserts = new InsertList();
        List<FieldMapping> fields = provider.mapping().allFields();
        Map<String, Object> map = entity.toEntityMap();
        for (FieldMapping f : fields) {
            if (f.isPrimary() && !withPk) continue;
            inserts.add(prefix, f, map.get(f.name), f.insert);
        }
        return inserts;
    }

    @Override
    public String insertSelect(String tableName, String[] fields, IQuery query) {
        MybatisUtil.assertNotBlank("tableName", tableName);
        MybatisUtil.assertNotEmpty("fields", fields);
        MybatisUtil.assertNotNull("ew", query);
        String columns = Stream.of(fields).map(arg_0 -> ((DbType)this.dbType).wrap(arg_0)).collect(Collectors.joining(", "));
        String select = query.getWrapperData().getSqlSelect();
        if (If.isBlank(select) || "*".equals(select)) {
            ((BaseQuery)query).select(fields);
        }
        return "INSERT INTO " + tableName + " (" + columns + ") " + query.getWrapperData().getQuerySql();
    }

    @Override
    public <E extends IEntity> String insertBatch(SqlProvider provider, List<E> entities, boolean withPk) {
        MapperSql sql = new MapperSql();
        List<Map> maps = this.toMaps(provider, entities, withPk);
        List<FieldMapping> nonFields = this.nonFields(provider, maps, withPk);
        String tableName = CommonSqlKit.dynamic((IEntity)entities.get(0), provider.tableName());
        sql.INSERT_INTO(tableName == null ? provider.tableName() : tableName);
        sql.INSERT_COLUMNS(provider.dbType(), nonFields.stream().map(f -> f.column).collect(Collectors.toList()));
        sql.VALUES();
        for (int index = 0; index < maps.size(); ++index) {
            if (index > 0) {
                sql.APPEND(", ");
            }
            ArrayList<String> values = new ArrayList<String>();
            for (FieldMapping f2 : nonFields) {
                values.add(InsertList.el("list[" + index + "].", f2, maps.get(index).get(f2.column), f2.insert));
            }
            sql.INSERT_VALUES(values);
        }
        return sql.toString();
    }

    @Override
    public String deleteById(SqlProvider provider, Serializable[] ids) {
        MapperSql sql = new MapperSql();
        sql.DELETE_FROM(provider.tableName(), null);
        this.whereEqIds(provider, sql, ids);
        return sql.toString();
    }

    @Override
    public String deleteByIds(SqlProvider provider, Collection ids) {
        MapperSql sql = new MapperSql();
        sql.DELETE_FROM(provider.tableName(), null);
        sql.WHERE_PK_IN(this.dbType.wrap(provider.mapping().primaryId(true)), ids.size());
        return sql.toString();
    }

    @Override
    public String logicDeleteById(SqlProvider provider, Serializable[] ids) {
        return this.logicDeleted(provider, sql -> this.whereEqIds(provider, (MapperSql)sql, ids));
    }

    @Override
    public String logicDeleteByIds(SqlProvider provider, Collection ids) {
        return this.logicDeleted(provider, sql -> sql.WHERE_PK_IN(this.dbType.wrap(provider.mapping().primaryId(true)), ids.size()));
    }

    @Override
    public String deleteByMap(SqlProvider provider, Map<String, Object> map) {
        MapperSql sql = new MapperSql();
        sql.DELETE_FROM(provider.tableName(), null);
        this.whereByMap(sql, map);
        return sql.toString();
    }

    @Override
    public String logicDeleteByMap(SqlProvider provider, Map<String, Object> map) {
        return this.logicDeleted(provider, sql -> this.whereByMap((MapperSql)sql, map));
    }

    @Override
    public String deleteBy(SqlProvider provider, WrapperData ew) {
        if (If.notBlank(ew.getCustomizedSql())) {
            return ew.getCustomizedSql();
        }
        MapperSql sql = new MapperSql();
        sql.DELETE_FROM(ew.getTable(), ew);
        sql.WHERE_GROUP_ORDER_BY(ew);
        return sql.toString();
    }

    @Override
    public String logicDeleteBy(SqlProvider provider, WrapperData ew) {
        if (If.notBlank(ew.getCustomizedSql())) {
            return ew.getCustomizedSql();
        }
        return this.logicDeleted(provider, sql -> sql.WHERE_GROUP_ORDER_BY(ew));
    }

    @Override
    public String updateBy(SqlProvider provider, IUpdate[] updaters) {
        ArrayList<String> list = new ArrayList<String>(updaters.length);
        int index = 0;
        for (IUpdate updater : updaters) {
            String sql = this.updateBy(provider, updater.getWrapperData());
            sql = SqlProviderKit.addEwParaIndex(sql, String.format("[%d]", index));
            ++index;
            list.add(sql);
        }
        return String.join((CharSequence)";\n", list);
    }

    @Override
    public String updateBy(SqlProvider provider, WrapperData ew) {
        MybatisUtil.assertNotNull("wrapperData of updater", ew);
        if (If.notBlank(ew.getCustomizedSql())) {
            return ew.getCustomizedSql();
        }
        Map<String, String> updates = ew.getUpdates();
        MybatisUtil.assertNotEmpty("updates", updates);
        MapperSql sql = new MapperSql();
        sql.UPDATE(ew.getTable(), ew);
        List<String> needDefaults = CommonSqlKit.updateDefaults(provider, updates, ew.isIgnoreLockVersion());
        String versionField = provider.mapping().versionField();
        if (ew.isIgnoreLockVersion() && If.notBlank(versionField)) {
            needDefaults.remove(provider.mapping().versionField());
        }
        needDefaults.add(ew.getUpdateStr());
        sql.SET(needDefaults);
        if (!ew.isIgnoreLockVersion()) {
            this.checkUpdateVersionWhere(provider, ew.findWhereColumns());
        }
        sql.WHERE_GROUP_ORDER_BY(ew);
        sql.LIMIT(ew, true);
        return sql.toString();
    }

    @Override
    public String updateById(SqlProvider provider, IEntity entity) {
        MapperSql sql = new MapperSql();
        sql.UPDATE(provider.tableName());
        UpdateSet updates = new UpdateSet();
        List<FieldMapping> fields = provider.mapping().allFields();
        FieldMapping primary = null;
        FieldMapping version = null;
        Map<String, Object> columns = entity.toColumnMap();
        for (FieldMapping f : fields) {
            if (f.isPrimary()) {
                primary = f;
                continue;
            }
            if (f.isVersion()) {
                version = f;
                updates.add(this.dbType, f, null, f.update);
                continue;
            }
            updates.add(this.dbType, f, columns.get(f.column), f.update);
        }
        sql.SET(updates.getUpdates());
        if (primary == null) {
            throw new IllegalArgumentException("Primary of entity is not defined.");
        }
        sql.WHERE(primary.el(this.dbType, "et"));
        if (version != null) {
            MybatisUtil.assertNotNull("lock version field(" + version.name + ")", columns.get(version.column));
            sql.APPEND(" AND " + version.el(this.dbType, "et"));
        }
        return sql.toString();
    }

    @Override
    public String countNoLimit(SqlProvider provider, WrapperData ew) {
        if (If.notBlank(ew.getCustomizedSql())) {
            return ew.getCustomizedSql();
        }
        MapperSql sql = new MapperSql();
        sql.COUNT(ew.getTable(), ew);
        sql.WHERE_GROUP_BY(ew);
        return sql.toString();
    }

    @Override
    public String count(SqlProvider provider, WrapperData ew) {
        if (If.notBlank(ew.getCustomizedSql())) {
            return ew.getCustomizedSql();
        }
        MapperSql sql = new MapperSql();
        sql.COUNT(ew.getTable(), ew);
        sql.WHERE_GROUP_ORDER_BY(ew);
        return SqlProviderKit.byPaged(this.dbType, ew, sql.toString());
    }

    @Override
    public String queryByQuery(SqlProvider provider, WrapperData ew) {
        if (If.notBlank(ew.getCustomizedSql())) {
            return ew.getCustomizedSql();
        }
        String sql = this.querySql(provider, ew);
        if (!ew.hasUnion()) {
            return sql;
        }
        StringBuilder buff = new StringBuilder("(").append(sql).append(")");
        for (WrapperData.Union union : ew.unions()) {
            WrapperData data = union.getQuery().getWrapperData();
            buff.append(" ").append(union.getKey()).append(" ");
            buff.append("(").append(this.querySql(provider, data)).append(")");
        }
        return buff.toString();
    }

    private String querySql(SqlProvider provider, WrapperData ew) {
        MapperSql sql = new MapperSql();
        sql.SELECT(ew.getTable(), ew, provider.mapping().getSelectAll());
        sql.WHERE_GROUP_ORDER_BY(ew);
        return SqlProviderKit.byPaged(this.dbType, ew, sql.toString());
    }

    @Override
    public String queryByMap(SqlProvider provider, Map where) {
        MapperSql sql = new MapperSql();
        sql.SELECT(provider.tableName(), provider.mapping().getSelectAll());
        sql.WHERE(this.dbType, "cm", where);
        return sql.toString();
    }

    @Override
    public String queryByIds(SqlProvider provider, Collection ids) {
        MapperSql sql = new MapperSql();
        sql.SELECT(provider.tableName(), provider.mapping().getSelectAll());
        sql.WHERE_PK_IN(this.dbType.wrap(provider.mapping().primaryId(true)), ids.size());
        return sql.toString();
    }

    @Override
    public String queryById(SqlProvider provider, Serializable id) {
        MapperSql sql = new MapperSql();
        sql.SELECT(provider.tableName(), provider.mapping().getSelectAll());
        sql.WHERE(String.format("%s = #{value}", this.dbType.wrap(provider.mapping().primaryId(true))));
        return sql.toString();
    }

    private void whereByMap(MapperSql sql, Map<String, Object> map) {
        ArrayList<String> where = new ArrayList<String>();
        for (String key : map.keySet()) {
            where.add(String.format("%s = #{%s.%s}", this.dbType.wrap(key), "cm", key));
        }
        sql.WHERE(where);
    }

    private String logicDeleted(SqlProvider provider, Consumer<MapperSql> where) {
        MapperSql sql = new MapperSql();
        String logicDeleted = provider.mapping().logicDeleteField();
        MybatisUtil.assertNotNull("logical delete field of table(" + provider.tableName() + ")", logicDeleted);
        sql.UPDATE(provider.tableName(), null);
        if (provider.mapping().longTypeOfLogicDelete()) {
            sql.SET(String.format("%s = %d", this.dbType.wrap(logicDeleted), System.currentTimeMillis()));
        } else {
            sql.SET(String.format("%s = true", this.dbType.wrap(logicDeleted)));
        }
        where.accept(sql);
        return sql.toString();
    }

    protected <E extends IEntity> List<Map> toMaps(SqlProvider provider, List<E> entities, boolean withPk) {
        ArrayList<Map> maps = new ArrayList<Map>(entities.size());
        for (IEntity entity : entities) {
            this.validateInsertEntity(entity, withPk, provider::setEntityByDefault);
            maps.add(entity.toColumnMap());
        }
        return maps;
    }

    protected List<FieldMapping> nonFields(SqlProvider provider, List<Map> maps, boolean withPk) {
        HashSet set = new HashSet();
        maps.forEach(m -> set.addAll(m.keySet()));
        return provider.mapping().allFields().stream().filter(f -> set.contains(f.column) || If.notBlank(f.insert)).filter(f -> !f.isPrimary() || withPk).collect(Collectors.toList());
    }

    private boolean validateInsertEntity(IEntity entity, boolean withPk, Consumer<IEntity> setByDefault) {
        PkGeneratorKits.setPkByGenerator(entity);
        if (withPk) {
            MybatisUtil.isTrue(entity.findPk() != null, "The pk of insert entity can't be null, you should use method insert without pk.", new Object[0]);
        } else {
            MybatisUtil.isTrue(entity.findPk() == null, "The pk of insert entity must be null, you should use method insert with pk.", new Object[0]);
        }
        setByDefault.accept(entity);
        return entity.findPk() != null;
    }

    protected void whereEqIds(SqlProvider provider, MapperSql sql, Serializable[] ids) {
        String idColumn = this.dbType.wrap(provider.mapping().primaryId(true));
        if (ids.length == 1) {
            sql.WHERE(String.format("%s = #{list[0]}", idColumn));
        } else {
            StringBuilder values = new StringBuilder();
            for (int index = 0; index < ids.length; ++index) {
                if (index > 0) {
                    values.append(", ");
                }
                values.append("#{list[").append(index).append("]}");
            }
            sql.WHERE(String.format("%s IN (%s)", idColumn, values));
        }
    }

    private void checkUpdateVersionWhere(SqlProvider provider, List<String> wheres) {
        String versionField = provider.mapping().versionField();
        if (If.notBlank(versionField) && !wheres.contains(versionField) && !wheres.contains(provider.dbType().wrap(versionField))) {
            throw new RuntimeException("The version lock field was explicitly set, but no version condition was found in the update condition.");
        }
    }

    static String dynamic(IEntity entity, String tableName) {
        if (entity instanceof IRichEntity) {
            String dynamic = entity.findTableBelongTo();
            return If.isBlank(dynamic) ? tableName : dynamic;
        }
        return tableName;
    }

    static List<String> updateDefaults(SqlProvider provider, Map<String, String> updates, boolean ignoreLockVersion) {
        List<FieldMapping> fields = provider.mapping().allFields();
        UpdateDefault defaults = new UpdateDefault(updates);
        for (FieldMapping f : fields) {
            if (If.isBlank(f.update) || f.isVersion() && ignoreLockVersion) continue;
            defaults.add(provider.dbType(), f, f.update);
        }
        return defaults.getUpdateDefaults();
    }
}

