/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.model;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.model.UniqueFieldType;
import cn.org.atool.fluent.mybatis.functions.IGetter;
import cn.org.atool.fluent.mybatis.functions.ISetter;
import cn.org.atool.fluent.mybatis.metadata.DbType;

public class FieldMapping<E extends IEntity> {
    public final String name;
    public final String column;
    public final UniqueFieldType uniqueFieldType;
    public final String insert;
    public final String update;
    public final Class javaType;
    public final Class typeHandler;
    public IGetter<E> getter;
    public ISetter<E> setter;

    public FieldMapping<E> sg(ISetter<E> setter, IGetter<E> getter) {
        if (this.setter != null || this.getter != null) {
            throw new RuntimeException("Secondary assignment is not allowed.");
        }
        this.getter = getter;
        this.setter = setter;
        return this;
    }

    public FieldMapping(String name, String column, UniqueFieldType uniqueFieldType, String insert, String update, Class javaType, Class typeHandler) {
        this.name = name;
        this.column = column;
        this.uniqueFieldType = uniqueFieldType;
        this.insert = insert;
        this.update = update;
        this.javaType = javaType;
        this.typeHandler = typeHandler;
    }

    public FieldMapping(String name, String column) {
        this(name, column, null, null, null, null, null);
    }

    public String toString() {
        return this.column;
    }

    public String el(DbType dbType, String prefix) {
        String _prefix;
        String string = _prefix = If.isBlank(prefix) ? "" : prefix + ".";
        if (this.typeHandler == null) {
            return dbType.wrap(this.column) + " = #{" + _prefix + this.name + "}";
        }
        return String.format("%s = #{%s%s, javaType=%s, typeHandler=%s}", dbType.wrap(this.column), _prefix, this.name, this.javaType.getName(), this.typeHandler.getName());
    }

    public String alias(String alias) {
        return FieldMapping.alias(alias, this.column);
    }

    public static String alias(String alias, String column) {
        return If.isBlank(alias) ? column : alias + "." + column;
    }

    public boolean isPrimary() {
        return this.uniqueFieldType == UniqueFieldType.PRIMARY_ID;
    }

    public boolean isVersion() {
        return this.uniqueFieldType == UniqueFieldType.LOCK_VERSION;
    }
}

