/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.model;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.segment.BaseWrapper;
import cn.org.atool.fluent.mybatis.segment.model.ColumnSegment;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;

public class Column {
    public static final Column EMPTY_COLUMN = new Column("", null){

        @Override
        protected DbType dbType() {
            return DbType.OTHER;
        }
    };
    private final String column;
    private final BaseWrapper wrapper;
    private final FieldMapping mapping;
    static final String Wrapper_Para = ".wrapperData.parameters.";

    private Column(String column, BaseWrapper wrapper) {
        this.column = column;
        this.wrapper = wrapper;
        this.mapping = wrapper == null ? null : wrapper.column(column);
    }

    public Column(FieldMapping mapping, BaseWrapper wrapper) {
        this.column = mapping.column;
        this.wrapper = wrapper;
        this.mapping = mapping;
    }

    public String wrapColumn() {
        String columnAs = this.column;
        if (this.isColumnNameAndNotAlias()) {
            columnAs = this.dbType().wrap(this.column);
        }
        String tAlias = "";
        if (this.wrapper != null && If.notBlank(this.wrapper.getTableAlias()) && this.isColumnNameAndNotAlias()) {
            tAlias = this.wrapper.getTableAlias() + ".";
        }
        return tAlias + columnAs;
    }

    protected DbType dbType() {
        if (this.wrapper != null && this.wrapper.dbType() != null) {
            return this.wrapper.dbType();
        }
        return DbType.OTHER;
    }

    public ColumnSegment columnSegment() {
        String columnAsAlias = this.wrapColumn();
        return ColumnSegment.column(columnAsAlias);
    }

    private boolean isColumnNameAndNotAlias() {
        if (this.wrapper == null) {
            return false;
        }
        String unWrapper = this.dbType().unwrap(this.column);
        return MybatisUtil.isColumnName(unWrapper) && !this.wrapper.getWrapperData().getFieldAlias().contains(unWrapper);
    }

    public boolean isAssignableFrom(Object para) {
        if (para == null || this.mapping == null || this.mapping.javaType == null || this.mapping.typeHandler == null) {
            return false;
        }
        Class<?> pClass = para.getClass();
        return this.mapping.javaType.isAssignableFrom(pClass);
    }

    public static boolean isFieldAndAssignableFrom(Column column, Object para) {
        return column != null && column.isAssignableFrom(para);
    }

    public static String wrapColumn(Column column, String paraName, Object para) {
        StringBuilder buff = new StringBuilder("#{").append("ew").append(Wrapper_Para).append(paraName);
        if (Column.isFieldAndAssignableFrom(column, para)) {
            buff.append(", ").append("javaType=").append(column.mapping.javaType.getName()).append(", ").append("typeHandler=").append(column.mapping.typeHandler.getName());
        }
        return buff.append("}").toString();
    }

    public static Column column(String column, BaseWrapper wrapper) {
        return new Column(column, wrapper);
    }

    public static Column column(FieldMapping mapping, BaseWrapper wrapper) {
        return new Column(mapping, wrapper);
    }

    public String toString() {
        return "Column[" + this.column + ']';
    }

    public String getColumn() {
        return this.column;
    }

    public BaseWrapper getWrapper() {
        return this.wrapper;
    }

    public FieldMapping getMapping() {
        return this.mapping;
    }
}

