/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.entity;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.BaseDefaults;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.entity.IEntityKit;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.model.UniqueFieldType;
import cn.org.atool.fluent.mybatis.functions.TableDynamic;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class AMapping<E extends IEntity, Q extends IQuery<E>, U extends IUpdate<E>>
extends BaseDefaults<E, Q, U>
implements IMapping,
IEntityKit {
    protected String schema;
    protected String tableName;
    private TableDynamic tableDynamic;
    private final DbType dbType;
    public final Map<String, FieldMapping> columnMap;
    public final Map<String, FieldMapping> fieldsMap;
    public final List<String> allFields;
    public final List<String> allColumns;
    public final String selectAll;
    protected Map<UniqueFieldType, FieldMapping> uniqueFields = new HashMap<UniqueFieldType, FieldMapping>(4);
    static final List<DbType> NeedSchemaDb = Arrays.asList(DbType.DERBY, DbType.POSTGRE_SQL, DbType.SQL_SERVER2012, DbType.SQL_SERVER2005);

    protected AMapping(DbType dbType) {
        this.dbType = dbType;
        this.columnMap = this.allFields().stream().collect(Collectors.toMap(f -> f.column, f -> f));
        this.fieldsMap = this.allFields().stream().collect(Collectors.toMap(f -> f.name, f -> f));
        this.allColumns = Collections.unmodifiableList(this.allFields().stream().map(f -> f.column).collect(Collectors.toList()));
        this.selectAll = this.allColumns.stream().map(arg_0 -> ((DbType)dbType).wrap(arg_0)).collect(Collectors.joining(", "));
        this.allFields = Collections.unmodifiableList(this.allFields().stream().map(f -> f.name).collect(Collectors.toList()));
    }

    @Override
    public abstract List<FieldMapping> allFields();

    @Override
    public String columnOfField(String field) {
        if (this.fieldsMap.containsKey(field)) {
            return this.fieldsMap.get((Object)field).column;
        }
        return null;
    }

    public <T extends IEntity> T toEntity(Map<String, Object> map) {
        Object entity = this.newEntity();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            FieldMapping f = this.fieldsMap.get(entry.getKey());
            if (f == null) continue;
            f.setter.set(entity, entry.getValue());
        }
        return (T)entity;
    }

    private Map<String, Object> toMap(IEntity entity, boolean isProperty, boolean isNoN) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.allFields.size());
        if (entity == null) {
            return map;
        }
        for (FieldMapping f : this.allFields()) {
            Object value = f.getter.get(entity);
            if (isNoN && value == null) continue;
            map.put(isProperty ? f.name : f.column, value);
        }
        return map;
    }

    @Override
    public Map<String, Object> toColumnMap(IEntity entity, boolean isNoN) {
        return this.toMap(entity, false, isNoN);
    }

    @Override
    public Map<String, Object> toEntityMap(IEntity entity, boolean isNoN) {
        return this.toMap(entity, true, isNoN);
    }

    @Override
    public <T> T valueByField(IEntity entity, String prop) {
        if (entity == null || prop == null) {
            return null;
        }
        FieldMapping f = this.fieldsMap.get(prop);
        return (T)(f == null ? null : f.getter.get(entity));
    }

    @Override
    public <T> T valueByColumn(IEntity entity, String column) {
        if (entity == null || column == null) {
            return null;
        }
        FieldMapping f = this.columnMap.get(column);
        return (T)(f == null ? null : f.getter.get(entity));
    }

    public <T extends IEntity> T copy(IEntity entity) {
        Object copy = this.newEntity();
        for (FieldMapping f : this.allFields()) {
            f.setter.set(copy, f.getter.get(entity));
        }
        return (T)copy;
    }

    @Override
    public Supplier<String> table() {
        if (this.tableDynamic != null) {
            return () -> this.tableDynamic.get(this.tableName);
        }
        if (NeedSchemaDb.contains(this.dbType) && If.notBlank(this.schema)) {
            return () -> this.schema + "." + this.dbType.wrap(this.tableName);
        }
        return () -> this.dbType.wrap(this.tableName);
    }

    @Override
    public Optional<FieldMapping> findField(UniqueFieldType type) {
        return Optional.ofNullable(this.uniqueFields.get((Object)type));
    }

    public String getSchema() {
        return this.schema;
    }

    @Override
    public DbType getDbType() {
        return this.dbType;
    }

    @Override
    public Map<String, FieldMapping> getColumnMap() {
        return this.columnMap;
    }

    public Map<String, FieldMapping> getFieldsMap() {
        return this.fieldsMap;
    }

    public List<String> getAllFields() {
        return this.allFields;
    }

    @Override
    public List<String> getAllColumns() {
        return this.allColumns;
    }

    @Override
    public String getSelectAll() {
        return this.selectAll;
    }

    public Map<UniqueFieldType, FieldMapping> getUniqueFields() {
        return this.uniqueFields;
    }

    public void setTableDynamic(TableDynamic tableDynamic) {
        this.tableDynamic = tableDynamic;
    }
}

