/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.dao;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.model.ISqlOp;
import cn.org.atool.fluent.mybatis.base.model.SqlOp;
import cn.org.atool.fluent.mybatis.base.model.UniqueFieldType;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.segment.BaseWrapper;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class DaoHelper {
    public static IUpdate buildUpdateEntityById(Supplier<IUpdate> supplier, IEntity entity) {
        IUpdate update = supplier.get();
        String primary = ((BaseWrapper)((Object)update)).fieldName(UniqueFieldType.PRIMARY_ID);
        String version = ((BaseWrapper)((Object)update)).fieldName(UniqueFieldType.LOCK_VERSION);
        Map<String, Object> map = entity.toColumnMap();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String column = entry.getKey();
            Object value = entry.getValue();
            if (Objects.equals(column, primary) || Objects.equals(column, version)) {
                if (If.isNull(value)) {
                    throw new FluentMybatisException("The condition[" + column + "] value of method[updateById(Entity)] cannot be null.");
                }
                update.where().apply(column, (ISqlOp)SqlOp.EQ, value);
                if (Objects.equals(column, primary)) {
                    primary = null;
                }
                if (!Objects.equals(column, version)) continue;
                version = null;
                continue;
            }
            update.updateSet(column, value);
        }
        if (primary != null) {
            throw new FluentMybatisException("In updateById method, the primary value cannot be null.");
        }
        if (version != null) {
            throw new FluentMybatisException("In updateById method, the lock version value cannot be null.");
        }
        return update;
    }

    public static IUpdate buildUpdateByEntityNoN(Supplier<IUpdate> supplier, IEntity update, IEntity where) {
        IUpdate updater = supplier.get();
        boolean hasUpdate = false;
        Map<String, Object> updateMap = update.toColumnMap();
        for (Map.Entry<String, Object> entry : updateMap.entrySet()) {
            Object value = entry.getValue();
            if (!If.notNull(value)) continue;
            updater.updateSet(entry.getKey(), value);
            hasUpdate = true;
        }
        if (!hasUpdate) {
            throw new RuntimeException("no update value found.");
        }
        boolean hasWhere = false;
        Map<String, Object> whereMap = where.toColumnMap();
        for (Map.Entry<String, Object> entry : whereMap.entrySet()) {
            Object value = entry.getValue();
            if (!If.notNull(value)) continue;
            updater.where().apply(entry.getKey(), (ISqlOp)SqlOp.EQ, value);
            hasWhere = true;
        }
        if (!hasWhere) {
            throw new RuntimeException("no where condition found.");
        }
        return updater;
    }
}

