/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.crud;

import cn.org.atool.fluent.mybatis.base.BatchCrud;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.IHasDbType;
import cn.org.atool.fluent.mybatis.base.IRef;
import cn.org.atool.fluent.mybatis.base.crud.IBaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IBaseUpdate;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.entity.PkGeneratorKits;
import cn.org.atool.fluent.mybatis.base.provider.SqlKit;
import cn.org.atool.fluent.mybatis.base.provider.SqlProvider;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.segment.BaseWrapper;
import cn.org.atool.fluent.mybatis.segment.WhereBase;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchCrudImpl
implements BatchCrud,
IHasDbType {
    protected final WrapperData wrapperData = new WrapperData();
    private final List<String> list = new ArrayList<String>();
    private static final Map<Class, SqlProvider> SQL_PROVIDER_MAP = new HashMap<Class, SqlProvider>();
    private static final String ENTITY_LIST_KEY = "list";
    private DbType dbType;

    public String batchSql() {
        return String.join((CharSequence)";\n", this.list);
    }

    @Override
    public BatchCrud addUpdate(IBaseUpdate ... updates) {
        for (IBaseUpdate updater : updates) {
            if (!(updater instanceof BaseWrapper)) {
                throw new IllegalArgumentException("the updater should be instance of BaseWrapper");
            }
            SqlProvider provider = this.findSqlProvider(updater.getWrapperData().getEntityClass());
            String sql = SqlKit.factory(provider).updateBy(provider, updater.getWrapperData());
            updater.getWrapperData().sharedParameter(this.wrapperData);
            this.list.add(sql);
        }
        return this;
    }

    @Override
    public BatchCrud addDelete(IBaseQuery ... deletes) {
        for (IBaseQuery query : deletes) {
            if (!(query instanceof BaseWrapper)) {
                throw new IllegalArgumentException("the query should be instance of BaseWrapper");
            }
            SqlProvider provider = this.findSqlProvider(query.getWrapperData().getEntityClass());
            String sql = SqlKit.factory(provider).deleteBy(provider, query.getWrapperData());
            query.getWrapperData().sharedParameter(this.wrapperData);
            this.list.add(sql);
        }
        return this;
    }

    private SqlProvider findSqlProvider(Class<? extends IEntity> klass) {
        if (SQL_PROVIDER_MAP.containsKey(klass)) {
            return SQL_PROVIDER_MAP.get(klass);
        }
        Map<Class, SqlProvider> map = SQL_PROVIDER_MAP;
        synchronized (map) {
            if (SQL_PROVIDER_MAP.containsKey(klass)) {
                return SQL_PROVIDER_MAP.get(klass);
            }
            String klassName = this.buildSqlProviderClassName(klass);
            try {
                Class<?> providerKlass = Class.forName(klassName);
                SqlProvider provider = (SqlProvider)providerKlass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                SQL_PROVIDER_MAP.put(klass, provider);
                return provider;
            }
            catch (Exception e) {
                throw new RuntimeException("findSqlProvider[" + klassName + "] error:" + e.getMessage(), e);
            }
        }
    }

    private String buildSqlProviderClassName(Class<? extends IEntity> klass) {
        Class<?> mapper = IRef.mapper(klass).getClass();
        if (mapper.getName().contains("$Proxy")) {
            mapper = mapper.getInterfaces()[0];
        }
        return mapper.getName() + "$" + "MapperSqlProvider";
    }

    @Override
    public BatchCrud addInsert(IEntity ... entities) {
        for (IEntity entity : entities) {
            if (entity == null) continue;
            if (!this.wrapperData.getParameters().containsKey(ENTITY_LIST_KEY)) {
                this.wrapperData.getParameters().put(ENTITY_LIST_KEY, (Object)new ArrayList());
            }
            SqlProvider provider = this.findSqlProvider(entity.getClass());
            List values = (List)this.wrapperData.getParameters().get(ENTITY_LIST_KEY);
            int index = values.size();
            values.add(entity);
            String prefix = String.format("ew.wrapperData.parameters.%s[%d].", ENTITY_LIST_KEY, index);
            PkGeneratorKits.setPkByGenerator(entity);
            String sql = SqlKit.factory(this).insertEntity(provider, prefix, entity, entity.findPk() != null);
            this.list.add(sql);
        }
        return this;
    }

    @Override
    public BatchCrud addInsertSelect(String insertTable, String[] fields, IQuery query) {
        MybatisUtil.assertNotNull("query", query);
        query.getWrapperData().sharedParameter(this.wrapperData);
        String sql = SqlKit.factory(this).insertSelect(insertTable, fields, query);
        this.list.add(sql);
        return this;
    }

    public WhereBase where() {
        throw new IllegalStateException("not supported by BatchUpdater.");
    }

    @Override
    public DbType dbType() {
        return this.dbType == null ? IRef.instance().defaultDbType() : this.dbType;
    }

    @Override
    public WrapperData getWrapperData() {
        return this.wrapperData;
    }

    @Override
    public BatchCrudImpl setDbType(DbType dbType) {
        this.dbType = dbType;
        return this;
    }
}

