/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.crud;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.IBaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.JoinBuilder;
import cn.org.atool.fluent.mybatis.base.crud.JoinToBuilder;
import cn.org.atool.fluent.mybatis.base.model.Column;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.model.UniqueFieldType;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.metadata.JoinType;
import cn.org.atool.fluent.mybatis.segment.BaseWrapper;
import cn.org.atool.fluent.mybatis.segment.JoinOn;
import cn.org.atool.fluent.mybatis.segment.model.PagedOffset;
import java.util.List;
import java.util.function.Supplier;

public abstract class BaseQuery<E extends IEntity, Q extends BaseQuery<E, Q>>
extends BaseWrapper<E, Q, Q>
implements IBaseQuery<E, Q> {
    protected BaseQuery(Supplier<String> table, String alias, Class entityClass, Class queryClass) {
        super(table, alias, entityClass, queryClass);
    }

    @Override
    public Q distinct() {
        this.wrapperData.setDistinct(true);
        return (Q)this;
    }

    @Override
    public Q selectAll() {
        this.allFields().stream().map(c -> FieldMapping.alias(this.tableAlias, c)).forEach(xva$0 -> this.select((String)xva$0));
        return (Q)this;
    }

    @Override
    public Q selectId() {
        String primary = this.fieldName(UniqueFieldType.PRIMARY_ID);
        if (primary == null) {
            throw new FluentMybatisException("The primary key of in table[" + this.wrapperData.getTable() + "] was not found.");
        }
        return this.select(primary);
    }

    public Q select(String ... columns) {
        for (String column : columns) {
            Column _column = Column.column(column, (BaseWrapper)this);
            this.wrapperData.addSelectColumn(_column.wrapColumn());
        }
        return (Q)this;
    }

    @Override
    public Q limit(int limit) {
        return (Q)this.limit(0, limit);
    }

    @Override
    public Q limit(int from, int limit) {
        this.wrapperData.setPaged(new PagedOffset(from, limit));
        return (Q)this;
    }

    @Override
    public Q last(String lastSql) {
        this.wrapperData.last(lastSql);
        return (Q)this;
    }

    @Override
    public List<String> allFields() {
        return super.allFields();
    }

    public Q union(IBaseQuery ... queries) {
        return this.union("UNION", queries);
    }

    public Q unionAll(IBaseQuery ... queries) {
        return this.union("UNION ALL", queries);
    }

    private Q union(String key, IBaseQuery ... queries) {
        if (this.wrapperData.getPaged() != null) {
            throw new RuntimeException("Limit syntax is not supported for union queries.");
        }
        if (queries == null || queries.length == 0) {
            throw new IllegalArgumentException("The size of parameter[queries] should be greater than zero.");
        }
        for (IBaseQuery query : queries) {
            String sql = query.getWrapperData().getQuerySql();
            this.wrapperData.union(key, query);
            query.getWrapperData().sharedParameter(this.wrapperData);
        }
        return (Q)this;
    }

    public <QR extends BaseQuery<?, QR>> JoinOn<Q, QR, JoinToBuilder<Q>> join(QR query) {
        return JoinBuilder.from(this).join(query);
    }

    public <QR extends BaseQuery<?, QR>> JoinOn<Q, QR, JoinToBuilder<Q>> join(JoinType joinType, QR query) {
        switch (joinType) {
            case LeftJoin: {
                return JoinBuilder.from(this).leftJoin(query);
            }
            case RightJoin: {
                return JoinBuilder.from(this).rightJoin(query);
            }
        }
        return JoinBuilder.from(this).join(query);
    }
}

