/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base;

import cn.org.atool.fluent.mybatis.annotation.NotField;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.IRef;
import cn.org.atool.fluent.mybatis.base.entity.IRichEntity;
import cn.org.atool.fluent.mybatis.functions.TableSupplier;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public abstract class RichEntity
implements IEntity,
IRichEntity {
    @NotField
    protected transient Map<String, Optional<Object>> cached = new ConcurrentHashMap<String, Optional<Object>>(4);
    private TableSupplier supplier;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T invoke(boolean cached, String methodName, Object[] args) {
        if (cached) {
            if (this.cached.containsKey(methodName)) {
                return this.cached.get(methodName).orElse(null);
            }
            RichEntity richEntity = this;
            synchronized (richEntity) {
                if (this.cached.containsKey(methodName)) {
                    return this.cached.get(methodName).orElse(null);
                }
                Object result = IRef.instance().invoke(this.getClass(), methodName, this.reArgs(args));
                this.cached.put(methodName, Optional.ofNullable(result));
                return result;
            }
        }
        return IRef.instance().invoke(this.getClass(), methodName, this.reArgs(args));
    }

    @Override
    public <T> T invoke(String method, boolean cached) {
        return this.invoke(cached, method, new Object[0]);
    }

    private Object[] reArgs(Object[] args) {
        if (args == null || args.length == 0) {
            return new Object[]{this};
        }
        Object[] reArgs = new Object[args.length + 1];
        reArgs[0] = this;
        System.arraycopy(args, 0, reArgs, 1, args.length);
        return reArgs;
    }

    @Override
    public <E extends IEntity> E changeTableBelongTo(TableSupplier supplier) {
        this.supplier = supplier;
        return (E)this;
    }

    @Override
    public <E extends IEntity> E changeTableBelongTo(String table) {
        this.supplier = e -> table;
        return (E)this;
    }

    @Override
    public String findTableBelongTo() {
        return this.supplier == null ? null : this.supplier.get(this);
    }
}

