/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.utility;

import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import java.util.Map;

public class SqlProviderUtils {
    public static final String WRAPPER_PARAM_FORMAT = "#{%s.parameters.%s}";
    public static final String Wrapper_Data = String.format("%s.wrapperData", "ew");

    public static WrapperData getWrapperData(Map map, String paraName) {
        IWrapper wrapper = SqlProviderUtils.getWrapper(map, paraName);
        if (wrapper.getWrapperData() == null) {
            throw new RuntimeException("no query condition found.");
        }
        return wrapper.getWrapperData();
    }

    public static IWrapper getWrapper(Map map, String paraName) {
        IWrapper wrapper = (IWrapper)map.get(paraName);
        if (wrapper == null) {
            throw new RuntimeException("param[" + paraName + "] not found.");
        }
        return wrapper;
    }

    public static <O> O getParas(Map map, String paraName) {
        Object obj = map.get(paraName);
        if (obj == null) {
            throw new RuntimeException("param[" + paraName + "] not found.");
        }
        return (O)obj;
    }

    public static String byPaged(DbType dbType, WrapperData data, String sql) {
        if (data.getPaged() == null) {
            return sql;
        }
        String pagedOffset = data.getParameters().putParameter(data.getPaged().getOffset());
        String pagedEndOffset = data.getParameters().putParameter(data.getPaged().getEndOffset());
        String pagedSize = data.getParameters().putParameter(data.getPaged().getLimit());
        switch (dbType) {
            case ORACLE: {
                return new StringBuilder(sql.length() + 200).append("SELECT * FROM ( ").append(" SELECT TMP_PAGE.*, ROWNUM ROW_ID FROM ( ").append(sql).append(" ) TMP_PAGE)").append(String.format(" WHERE ROW_ID > %s AND ROW_ID <= %s ", pagedOffset, pagedEndOffset)).toString();
            }
            case DB2: {
                return new StringBuilder(sql.length() + 200).append("SELECT * FROM (SELECT TMP_PAGE.*,ROWNUMBER() OVER() AS ROW_ID FROM ( ").append(sql).append(" ) AS TMP_PAGE) TMP_PAGE WHERE ROW_ID").append(String.format(" BETWEEN %s AND %s", pagedOffset, pagedSize)).toString();
            }
            case SQL_SERVER: 
            case SQL_SERVER2005: {
                throw new RuntimeException("not support");
            }
            case HSQL: 
            case POSTGRE_SQL: {
                return sql + String.format(" LIMIT %s OFFSET %s", pagedSize, pagedOffset);
            }
        }
        return sql + String.format(" LIMIT %s, %s ", pagedOffset, pagedSize);
    }
}

