/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.utility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SqlInject {
    private static final String[] KEYWORDS = new String[]{"and", "or", "not", "use", "insert", "delete", "update", "select", "count", "group", "union", "create", "drop", "truncate", "alter", "grant", "execute", "exec", "xp_cmdshell", "call", "declare", "source", "sql"};
    private static final List<String> DANGER_CHAR = Arrays.asList(";", "--", "*", "%", "\\", "'", "#", "/");
    private static Map<Character, List<char[]>> KEYWORD_MAP = SqlInject.initMap(KEYWORDS);
    private static Map<Character, List<char[]>> DANGER_MAP = SqlInject.initMap(DANGER_CHAR.toArray(new String[0]));
    private static String KEYWORD_STR = "[" + Stream.of(KEYWORDS).collect(Collectors.joining(",")) + "]";
    private static String DANGER_STR = "[" + DANGER_CHAR.stream().collect(Collectors.joining(",")) + "]";
    private static final int TO_UPPER = -32;

    private static Map<Character, List<char[]>> initMap(String ... words) {
        HashMap<Character, List<char[]>> map = new HashMap<Character, List<char[]>>(256);
        Stream.of(words).forEach(word -> {
            char[] chars = word.toCharArray();
            char first = Character.toLowerCase(chars[0]);
            if (!map.containsKey(Character.valueOf(first))) {
                map.put(Character.valueOf(first), new ArrayList());
                map.put(Character.valueOf(Character.toUpperCase(first)), (List<char[]>)map.get(Character.valueOf(first)));
            }
            ((List)map.get(Character.valueOf(first))).add(Arrays.copyOfRange(chars, 1, chars.length));
        });
        return map;
    }

    public static String assertNoInject(String propertyName, String propertyValue) {
        if (SqlInject.probablySqlInject(propertyValue)) {
            throw new RuntimeException(propertyName + " can't contain following KeyWord: " + KEYWORD_STR + " or following danger characters: " + DANGER_STR);
        }
        return propertyValue;
    }

    public static boolean probablySqlInject(String str) {
        if (str == null) {
            return false;
        }
        boolean isWordStart = true;
        int length = str.length();
        int index = 0;
        for (char ch : str.toCharArray()) {
            ++index;
            if (SqlInject.isBlank(ch)) {
                isWordStart = true;
                continue;
            }
            if (isWordStart && SqlInject.isKeyWord(str, length, KEYWORD_MAP.get(Character.valueOf(ch)), index, false)) {
                return true;
            }
            if (SqlInject.isKeyWord(str, length, DANGER_MAP.get(Character.valueOf(ch)), index, true)) {
                return true;
            }
            isWordStart = false;
        }
        return false;
    }

    private static boolean isKeyWord(String str, int length, List<char[]> charsList, int index, boolean isDanger) {
        if (charsList == null) {
            return false;
        }
        for (char[] chars : charsList) {
            if (!SqlInject.isKeyWord(str, length, chars, index, isDanger)) continue;
            return true;
        }
        return false;
    }

    private static boolean isKeyWord(String str, int length, char[] chars, int index, boolean isDanger) {
        int start = index;
        for (char ch : chars) {
            if (start >= length) {
                return false;
            }
            char charAt = str.charAt(start);
            if (ch != charAt && ch + -32 != charAt) {
                return false;
            }
            ++start;
        }
        return isDanger || start == length || SqlInject.isBlank(str.charAt(start));
    }

    private static boolean isBlank(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r' || ch == '\u0000';
    }

    public static boolean hasSimpleInject(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        int index = 0;
        for (char ch : str.toCharArray()) {
            if (!SqlInject.isKeyWord(str, length, DANGER_MAP.get(Character.valueOf(ch)), ++index, true)) continue;
            return true;
        }
        return false;
    }

    public static String assertSimpleNoInject(String propertyName, String propertyValue) {
        if (SqlInject.hasSimpleInject(propertyValue)) {
            throw new RuntimeException(propertyName + " can't contain following string: " + DANGER_STR);
        }
        return propertyValue;
    }
}

