/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.utility;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.annotation.NotField;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MybatisUtil {
    static Map<Character, String> Escape_Char = new HashMap<Character, String>();
    private static final List<String> PROXY_CLASS_NAMES;
    public static final char UNDERLINE = '_';

    public static String format(String target, Object ... params) {
        if (target.contains("%s") && If.notEmpty(params)) {
            return String.format(target, params);
        }
        return target;
    }

    public static List<Field> getFieldList(Class<?> clazz) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Class<?> current = MybatisUtil.getProxyTargetClass(clazz); current.getSuperclass() != null && current != Object.class; current = current.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = current.getDeclaredFields()) {
                if (MybatisUtil.isStatic(field) || field.getAnnotation(NotField.class) != null || map.containsKey(field.getName())) continue;
                map.put(field.getName(), field);
            }
        }
        return new ArrayList<Field>(map.values());
    }

    private static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers());
    }

    public static Class<?> getProxyTargetClass(Class<?> clazz) {
        if (clazz != null) {
            for (Class<?> klass : clazz.getInterfaces()) {
                if (!PROXY_CLASS_NAMES.contains(klass.getName())) continue;
                return clazz.getSuperclass();
            }
        }
        return clazz;
    }

    public static void assertNotNull(String property, Object value) {
        if (value == null) {
            throw FluentMybatisException.instance("the parameter[" + property + "] can't be null.", property);
        }
    }

    public static <T> void assertNotNull(String property, T value1, T value2) {
        if (value1 == null || value2 == null) {
            throw FluentMybatisException.instance("the parameter[%s] can't be null.", property);
        }
    }

    public static void assertNotBlank(String property, String value) {
        if (If.isBlank(value)) {
            throw FluentMybatisException.instance("the parameter[%s] can't be blank.", property);
        }
    }

    public static void assertNotEmpty(String property, Collection list) {
        if (list == null || list.size() == 0) {
            throw FluentMybatisException.instance("the parameter[%s] can't be empty.", property);
        }
    }

    public static void assertNotEmpty(String property, Map map) {
        if (map == null || map.size() == 0) {
            throw FluentMybatisException.instance("the parameter[%s] can't be empty.", property);
        }
    }

    public static void assertNotEmpty(String property, Object[] array) {
        if (array == null || array.length == 0) {
            throw FluentMybatisException.instance("the parameter[%s] can't be empty.", property);
        }
    }

    public static void isTrue(boolean expression, String message, Object ... params) {
        if (!expression) {
            throw FluentMybatisException.instance(message, params);
        }
    }

    public static void notNull(Object object, String message, Object ... params) {
        MybatisUtil.isTrue(object != null, message, params);
    }

    public static Integer[] toArray(int[] nums) {
        if (nums == null) {
            return null;
        }
        return (Integer[])Arrays.stream(nums).boxed().toArray(Integer[]::new);
    }

    public static Long[] toArray(long[] nums) {
        if (nums == null) {
            return null;
        }
        return (Long[])Arrays.stream(nums).boxed().toArray(Long[]::new);
    }

    public static <O> boolean isCollection(O ... args) {
        return args != null && args.length == 1 && args[0] instanceof Collection;
    }

    public static String trim(String str) {
        return If.isBlank(str) ? "" : str.trim();
    }

    public static String tableName(String klass, String prefix, String suffix) {
        if (klass.endsWith(suffix)) {
            klass = klass.substring(0, klass.length() - suffix.length());
        }
        return prefix + MybatisUtil.camelToUnderline(klass, false);
    }

    public static String camelToUnderline(String string, boolean toUpper) {
        if (If.isBlank(string)) {
            return "";
        }
        int len = string.length();
        StringBuilder buff = new StringBuilder(len + 10);
        for (int pos = 0; pos < len; ++pos) {
            char ch = string.charAt(pos);
            if (pos != 0 && Character.isUpperCase(ch)) {
                buff.append('_');
            }
            if (toUpper) {
                buff.append(Character.toUpperCase(ch));
                continue;
            }
            buff.append(Character.toLowerCase(ch));
        }
        return buff.toString();
    }

    public static String underlineToCamel(String input, boolean firstCapital) {
        if (If.isBlank(input)) {
            return "";
        }
        boolean first = true;
        boolean underline = false;
        StringBuilder buff = new StringBuilder(input.length());
        for (char ch : input.toCharArray()) {
            if (ch == '_') {
                if (first) continue;
                underline = true;
                continue;
            }
            if (first) {
                buff.append(firstCapital ? Character.toUpperCase(ch) : Character.toLowerCase(ch));
            } else if (underline) {
                buff.append(Character.toUpperCase(ch));
            } else {
                buff.append(ch);
            }
            first = false;
            underline = false;
        }
        return buff.toString();
    }

    public static String capitalFirst(String name, String del) {
        if (!If.isBlank(name)) {
            if (del != null && name.startsWith(del)) {
                name = name.substring(del.length());
            }
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }

    public static String lowerFirst(String name, String del) {
        if (!If.isBlank(name)) {
            if (del != null && name.startsWith(del)) {
                name = name.substring(del.length());
            }
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }

    public static String methodNameOfEntity(String method, Class entityClass) {
        return method + "Of" + entityClass.getSimpleName();
    }

    public static String methodNameOfEntity(String method, String entityClass) {
        return method + "Of" + entityClass;
    }

    public static RuntimeException notFluentMybatisException(Class clazz) {
        return new RuntimeException("the class[" + clazz.getName() + "] is not a @FluentMybatis Entity or it's sub class.");
    }

    public static boolean isColumnName(String input) {
        if (If.isBlank(input)) {
            return false;
        }
        int len = input.length();
        if (input.charAt(0) == '`' && input.charAt(len - 1) == '`') {
            --len;
        } else if (!MybatisUtil.isLetter(input.charAt(0))) {
            return false;
        }
        for (int index = 1; index < len; ++index) {
            char ch = input.charAt(index);
            if (MybatisUtil.isLetter(ch) || MybatisUtil.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_';
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static String getVersionBanner() {
        Package pkg = MybatisUtil.class.getPackage();
        String version = pkg != null ? pkg.getImplementationVersion() : "";
        StringBuilder buff = new StringBuilder().append("  _____   _                          _    \n").append(" |  ___| | |  _   _    ___   _ __   | |_  \n").append(" | |_    | | | | | |  ( _ ) | '_ L  | __| \n").append(" |  _|   | | | |_| | |  __) | | | | | |_  \n").append(" |_|     |_| |___,_| |____| |_| |_| |___| \n").append(" __  __         ____          _    _      \n").append("| )  ( | _   _ | __ )   __ _ | |_ (_) ___ \n").append("| |)(| || | | ||  _ L  { _` || __|| || __|\n").append("| |  | || |_| || |_) || (_| || |_ | |(__ )\n").append("|_|  |_| L__, ||____)  (__,_| L__||_||___}\n").append("         |___)                            \n").append(version == null ? "" : version + " \n");
        return buff.toString();
    }

    static {
        Escape_Char.put(Character.valueOf('\u0000'), "\\0");
        Escape_Char.put(Character.valueOf('\n'), "\\n");
        Escape_Char.put(Character.valueOf('\r'), "\\r");
        Escape_Char.put(Character.valueOf('\\'), "\\\\");
        Escape_Char.put(Character.valueOf('\''), "\\'");
        Escape_Char.put(Character.valueOf('\"'), "\\\"");
        Escape_Char.put(Character.valueOf('\u001a'), "\\Z");
        PROXY_CLASS_NAMES = Arrays.asList("net.sf.cglib.proxy.Factory", "org.springframework.cglib.proxy.Factory", "javassist.util.proxy.ProxyObject", "org.apache.ibatis.javassist.util.proxy.ProxyObject");
    }
}

