/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.utility;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.IRefs;
import cn.org.atool.fluent.mybatis.base.crud.FormSetter;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.model.SqlOp;
import cn.org.atool.fluent.mybatis.functions.FormApply;
import cn.org.atool.fluent.mybatis.model.Form;
import cn.org.atool.fluent.mybatis.model.FormItem;
import cn.org.atool.fluent.mybatis.model.IFormApply;
import cn.org.atool.fluent.mybatis.segment.WhereBase;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.PoJoHelper;
import java.util.Map;
import java.util.function.Supplier;

public class FormHelper {
    public static <E extends IEntity> IQuery toQuery(Class<E> entityClass, Form form) {
        MybatisUtil.assertNotNull("entityClass", entityClass);
        if (form.getNextId() != null && form.getCurrPage() != null) {
            throw new RuntimeException("nextId and currPage can only have one value");
        }
        IQuery query = IRefs.instance().defaultQuery(entityClass);
        WhereBase where = query.where();
        block10: for (FormItem item : form.getItems()) {
            String column = IRefs.instance().findColumnByField(entityClass, item.getKey());
            if (If.isBlank(column)) {
                throw new RuntimeException("the field[" + item.getKey() + "] of Entity[" + entityClass.getSimpleName() + "] not found.");
            }
            switch (item.getOp()) {
                case "LEFT_LIKE": {
                    ((WhereBase)where.and).apply(column, SqlOp.LIKE, item.getValue()[0] + "%");
                    continue block10;
                }
                case "LIKE": {
                    ((WhereBase)where.and).apply(column, SqlOp.LIKE, "%" + item.getValue()[0] + "%");
                    continue block10;
                }
                case "NOT_LIKE": {
                    ((WhereBase)where.and).apply(column, SqlOp.NOT_LIKE, "%" + item.getValue()[0] + "%");
                    continue block10;
                }
            }
            ((WhereBase)where.and).apply(column, SqlOp.valueOf(item.getOp()), item.getValue());
        }
        if (form.getCurrPage() != null) {
            int from = form.getPageSize() * (form.getCurrPage() - 1);
            query.limit(from, form.getPageSize());
        } else if (form.getNextId() != null) {
            String column = IRefs.instance().findPrimaryColumn(entityClass);
            ((WhereBase)where.and).apply(column, SqlOp.GE, form.getNextId());
            query.limit(form.getPageSize());
        }
        return query;
    }

    public static <E extends IEntity, S extends FormSetter> IFormApply<E, S> by(Object object, Form form, Supplier<S> setterSupplier) {
        MybatisUtil.assertNotNull("object", object);
        Map map = PoJoHelper.toMap(object);
        FormApply apply = new FormApply((FormSetter)setterSupplier.get(), map, form);
        return apply;
    }
}

