/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment.model;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.model.SqlOp;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.segment.model.ColumnSegment;
import cn.org.atool.fluent.mybatis.segment.model.HintType;
import cn.org.atool.fluent.mybatis.segment.model.ISqlSegment;
import cn.org.atool.fluent.mybatis.segment.model.IWrapperData;
import cn.org.atool.fluent.mybatis.segment.model.KeyWordSegment;
import cn.org.atool.fluent.mybatis.segment.model.MergeSegments;
import cn.org.atool.fluent.mybatis.segment.model.PagedOffset;
import cn.org.atool.fluent.mybatis.segment.model.Parameters;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class WrapperData
implements IWrapperData {
    protected boolean isDistinct = false;
    protected List<String> sqlSelect = new ArrayList<String>(8);
    protected Supplier<String> table;
    private String alias;
    protected final Parameters parameters;
    protected final MergeSegments mergeSegments = new MergeSegments();
    protected PagedOffset paged;
    private final Map<String, String> updates = new LinkedHashMap<String, String>(16);
    private final Map<HintType, String> hints = new HashMap<HintType, String>(4);
    private final Class entityClass;
    private final Class queryClass;

    public WrapperData() {
        this.parameters = new Parameters();
        this.queryClass = null;
        this.entityClass = null;
    }

    public WrapperData(Supplier<String> table, String alias, Parameters parameters, Class entityClass, Class queryClass) {
        MybatisUtil.notNull(entityClass, "entityClass must not null,please set entity before use this method!", new Object[0]);
        this.table = table;
        this.alias = alias;
        this.parameters = parameters;
        this.entityClass = entityClass;
        this.queryClass = queryClass;
    }

    public String getTable() {
        return If.isBlank(this.alias) ? this.table.get() : this.table.get() + " " + this.alias;
    }

    @Override
    public String getSqlSelect() {
        if (this.sqlSelect.isEmpty()) {
            return null;
        }
        String sql = this.sqlSelect.stream().collect(Collectors.joining(", "));
        return If.isBlank(sql) ? null : sql.trim();
    }

    public List<String> sqlSelect() {
        return this.sqlSelect;
    }

    @Override
    public String getQuerySql() {
        String select = this.getSqlSelect();
        String where = this.mergeSegments.where();
        String sql = String.format("SELECT %s FROM %s %s", select == null ? "*" : select, this.getTable(), where);
        return If.isBlank(sql) ? null : sql.trim();
    }

    @Override
    public String getUpdateStr() {
        String sql = this.updates.entrySet().stream().map(i -> (String)i.getKey() + " = " + (String)i.getValue()).collect(Collectors.joining(", "));
        return If.isBlank(sql) ? null : sql.trim();
    }

    @Override
    public String getMergeSql() {
        String sql = this.mergeSegments.sql();
        return If.isBlank(sql) ? null : sql.trim();
    }

    @Override
    public String getWhereSql() {
        return this.mergeSegments.whereSql();
    }

    @Override
    public String getGroupBy() {
        return this.mergeSegments.groupBy();
    }

    @Override
    public String getOrderBy() {
        return this.mergeSegments.orderBy();
    }

    @Override
    public String getLastSql() {
        return this.mergeSegments.last();
    }

    public void last(String lastSql) {
        this.mergeSegments.setLastSql(lastSql);
    }

    public void apply(KeyWordSegment keyWord, String column, SqlOp operator, Object ... paras) {
        this.apply(keyWord, column, operator, null, paras);
    }

    public void addSelectColumn(String column) {
        if (If.notBlank(column)) {
            this.sqlSelect.add(column);
        }
    }

    public void apply(KeyWordSegment keyWord, String column, SqlOp operator, String format, Object ... args) {
        if (keyWord == null) {
            throw new FluentMybatisException("the first segment should be: 'AND', 'OR', 'GROUP BY', 'HAVING' or 'ORDER BY'");
        }
        String segment = operator.operator(this.getParameters(), format, args);
        this.getMergeSegments().add(keyWord, ColumnSegment.column(column), () -> segment);
    }

    public void apply(KeyWordSegment keyWord, ISqlSegment ... segments) {
        if (keyWord == null) {
            throw new FluentMybatisException("the first segment should be: 'AND', 'OR', 'GROUP BY', 'HAVING' or 'ORDER BY'");
        }
        this.getMergeSegments().add(keyWord, segments);
    }

    public String paramSql(String functionSql, Object[] values) {
        return this.parameters.paramSql(functionSql, values);
    }

    public void updateSet(String column, Object value) {
        this.updateSql(column, "?", value);
    }

    public void updateSql(String column, String functionSql, Object ... values) {
        if (If.notBlank(functionSql)) {
            this.updates.put(column, this.paramSql(functionSql, values));
        }
    }

    public void hint(HintType type, String hint) {
        if (If.notBlank(hint)) {
            this.hints.put(type, hint);
        }
    }

    public String hint(HintType type) {
        String hint = this.hints.get((Object)type);
        return If.isBlank(hint) ? " " : " " + hint + " ";
    }

    public void setSharedParameter(WrapperData wrapperData) {
        this.getParameters().setSharedParameter(wrapperData.getParameters());
    }

    public void setSharedParameter(Parameters parameters) {
        this.getParameters().setSharedParameter(parameters);
    }

    @Override
    public boolean isDistinct() {
        return this.isDistinct;
    }

    public String getAlias() {
        return this.alias;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public MergeSegments getMergeSegments() {
        return this.mergeSegments;
    }

    public PagedOffset getPaged() {
        return this.paged;
    }

    public Map<String, String> getUpdates() {
        return this.updates;
    }

    public Map<HintType, String> getHints() {
        return this.hints;
    }

    public Class getQueryClass() {
        return this.queryClass;
    }

    public void setDistinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setPaged(PagedOffset paged) {
        this.paged = paged;
    }

    public Class getEntityClass() {
        return this.entityClass;
    }
}

