/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.base.crud.IBaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.model.SqlOp;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.functions.QFunction;
import cn.org.atool.fluent.mybatis.ifs.Ifs;
import cn.org.atool.fluent.mybatis.ifs.IfsPredicate;
import cn.org.atool.fluent.mybatis.segment.BaseApply;
import cn.org.atool.fluent.mybatis.segment.BaseWrapper;
import cn.org.atool.fluent.mybatis.segment.WhereBase;
import cn.org.atool.fluent.mybatis.segment.where.BooleanWhere;
import cn.org.atool.fluent.mybatis.segment.where.NumericWhere;
import cn.org.atool.fluent.mybatis.segment.where.ObjectWhere;
import cn.org.atool.fluent.mybatis.segment.where.StringWhere;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.NestedQueryFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class WhereApply<WHERE extends WhereBase<WHERE, ?, NQ>, NQ extends IBaseQuery<?, NQ>>
extends BaseApply<WHERE, NQ>
implements ObjectWhere<WHERE, NQ>,
NumericWhere<WHERE, NQ>,
StringWhere<WHERE, NQ>,
BooleanWhere<WHERE, NQ> {
    public WhereApply(WHERE where) {
        super(where);
    }

    @Override
    public <O> WHERE apply(SqlOp op, O ... args) {
        if (op.getArgSize() > 0) {
            MybatisUtil.assertNotEmpty(this.current().name, args);
            if (args.length != op.getArgSize()) {
                throw new FluentMybatisException(op.getArgSize() + " parameters are required, but " + args.length + " is passed in");
            }
            Stream.of(args).forEach(arg -> MybatisUtil.assertNotNull(this.current().name, arg));
        }
        if (op.getArgSize() == -1) {
            MybatisUtil.assertNotEmpty(this.current().name, args);
        }
        if (op == SqlOp.IN && args.length == 1) {
            Object value = args[0];
            if (value instanceof Collection) {
                Object[] arr = ((Collection)value).toArray();
                MybatisUtil.assertNotEmpty(this.current().name, arr);
                if (arr.length > 1) {
                    return ((WhereBase)this.segment).apply(this.current(), SqlOp.IN, arr);
                }
                value = arr[0];
            }
            return ((WhereBase)this.segment).apply(this.current(), SqlOp.EQ, value);
        }
        return ((WhereBase)this.segment).apply(this.current(), op, (Object[])args);
    }

    @Override
    public <T> WHERE apply(SqlOp op, Ifs<T> ifs) {
        if (ifs == null) {
            return this.apply(op, (O[])new Object[]{null});
        }
        if (op.getArgSize() > 1) {
            throw new IllegalArgumentException("Ifs condition does not apply to the operation:" + op.name());
        }
        for (IfsPredicate predicate : ifs.predicates) {
            Object value = predicate.value(op);
            if (!predicate.predicate.test(value)) continue;
            return this.apply(op, (O[])new Object[]{value});
        }
        return (WHERE)((WhereBase)this.segment);
    }

    @Override
    public <O> WHERE apply(Predicate<Object[]> predicate, SqlOp op, O ... args) {
        return (WHERE)(predicate.test(args) ? this.apply(op, args) : (WhereBase)this.segment);
    }

    @Override
    public <O> WHERE in(String select, O ... args) {
        if (MybatisUtil.isCollection(args)) {
            return ((WhereBase)this.segment).apply(this.current(), SqlOp.IN, select, ((Collection)args[0]).toArray());
        }
        return ((WhereBase)this.segment).apply(this.current(), SqlOp.IN, select, (Object[])args);
    }

    @Override
    public <O> WHERE in(boolean condition, String select, O ... args) {
        return (WHERE)(condition ? this.in(select, args) : (WhereBase)this.segment);
    }

    @Override
    public WHERE in(QFunction<NQ> query) {
        Object nested = NestedQueryFactory.nested(((WhereBase)this.segment).queryClass(), ((WhereBase)this.segment).wrapper);
        query.apply(nested);
        return this.in((IQuery)nested);
    }

    @Override
    public WHERE in(IQuery query) {
        ((BaseWrapper)((Object)query)).setSharedParameter(((WhereBase)this.segment).getParameters());
        return ((WhereBase)this.segment).apply(this.current(), SqlOp.IN, query.getWrapperData().getQuerySql(), new Object[0]);
    }

    @Override
    public WHERE in(boolean condition, QFunction<NQ> query) {
        return (WHERE)(condition ? this.in(query) : (WhereBase)this.segment);
    }

    @Override
    public WHERE in(boolean condition, IQuery query) {
        return (WHERE)(condition ? this.in(query) : (WhereBase)this.segment);
    }

    @Override
    public WHERE notIn(QFunction<NQ> query) {
        Object nested = NestedQueryFactory.nested(((WhereBase)this.segment).queryClass(), ((WhereBase)this.segment).wrapper);
        query.apply(nested);
        return this.notIn((IQuery)nested);
    }

    @Override
    public WHERE notIn(IQuery query) {
        ((BaseWrapper)((Object)query)).setSharedParameter(((WhereBase)this.segment).getParameters());
        return ((WhereBase)this.segment).apply(this.current(), SqlOp.NOT_IN, query.getWrapperData().getQuerySql(), new Object[0]);
    }

    @Override
    public WHERE notIn(boolean condition, QFunction<NQ> query) {
        return (WHERE)(condition ? this.notIn(query) : (WhereBase)this.segment);
    }

    @Override
    public WHERE notIn(boolean condition, IQuery query) {
        return (WHERE)(condition ? this.notIn(query) : (WhereBase)this.segment);
    }

    @Override
    public WHERE apply(String opArgs) {
        return ((WhereBase)this.segment).apply(this.current(), SqlOp.RETAIN, opArgs, new Object[0]);
    }

    @Override
    public WHERE applyFunc(SqlOp op, String expression, Object ... args) {
        return ((WhereBase)this.segment).apply(this.current(), op, expression, args);
    }

    @Override
    public WHERE applyFunc(Predicate<Object[]> predicate, SqlOp op, String expression, Object ... args) {
        if (predicate.test(args)) {
            this.apply(op, (O[])new Serializable[]{expression, args});
        }
        return ((WhereBase)this.segment).and;
    }
}

