/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.crud.IBaseQuery;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.functions.FieldPredicate;
import cn.org.atool.fluent.mybatis.functions.IAggregate;
import cn.org.atool.fluent.mybatis.segment.AggregateSegment;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.util.Objects;
import java.util.stream.Stream;

public abstract class SelectorBase<S extends SelectorBase<S, Q>, Q extends IBaseQuery<?, Q>>
extends AggregateSegment<S, Q, S> {
    private static final String AS = " AS ";

    protected SelectorBase(Q query) {
        super(query);
    }

    protected SelectorBase(S origin, IAggregate aggregate) {
        super(origin, aggregate);
    }

    public S apply(String column, String ... columns) {
        if (this.aggregate != null) {
            if (columns == null || columns.length > 0) {
                throw new RuntimeException("Aggregate functions allow only one column.");
            }
            return this.applyAs(column, null);
        }
        this.applyAs(column, null);
        if (If.notEmpty(columns)) {
            Stream.of(columns).forEach(c -> this.applyAs((String)c, null));
        }
        return (S)((SelectorBase)super.getOrigin());
    }

    public S apply(FieldMapping ... columns) {
        if (columns == null || columns.length == 0) {
            throw new RuntimeException("Apply column missing.");
        }
        if (this.aggregate != null) {
            if (columns.length != 1) {
                throw new RuntimeException("Aggregate functions allow only one column.");
            }
            this.current = columns[0];
            return this.applyAs(columns[0].column, null);
        }
        Stream.of(columns).filter(Objects::nonNull).map(this::columnWithAlias).forEach(this.wrapperData()::addSelectColumn);
        return (S)((SelectorBase)super.getOrigin());
    }

    public S applyAs(FieldMapping field, String alias) {
        return this.applyAs(field.column, alias);
    }

    public S applyAs(String column, String alias) {
        String select = column;
        if (If.notBlank(this.wrapper.tableAlias) && MybatisUtil.isColumnName(column)) {
            select = this.wrapper.tableAlias + "." + column;
        }
        if (this.aggregate != null) {
            select = this.aggregate.aggregate(select);
        }
        if (If.notBlank(alias)) {
            select = select + AS + alias;
        }
        this.wrapperData().addSelectColumn(select);
        return (S)((SelectorBase)super.getOrigin());
    }

    public S count(String alias) {
        return this.applyAs("count(*)", alias);
    }

    public S apply(FieldPredicate predicate) {
        String select = this.wrapper.getTableMeta().filter(false, predicate);
        this.wrapperData().addSelectColumn(select);
        return (S)((SelectorBase)super.getOrigin());
    }

    @Override
    protected S apply() {
        return this.applyAs(this.current.column, null);
    }

    protected S process(FieldMapping field, String alias) {
        this.current = field;
        return this.applyAs(field, alias);
    }

    private S apply(IAggregate aggregate, String alias) {
        if (this.current == null) {
            return (S)(this.origin == null ? this : (SelectorBase)this.origin);
        }
        String expression = aggregate == null ? this.currentWithAlias() : aggregate.aggregate(this.currentWithAlias());
        return this.applyAs(expression, alias);
    }
}

