/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.BaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IBaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.JoinBuilder;
import cn.org.atool.fluent.mybatis.base.crud.JoinBuilder1;
import cn.org.atool.fluent.mybatis.base.crud.JoinBuilder2;
import cn.org.atool.fluent.mybatis.functions.QFunction;
import cn.org.atool.fluent.mybatis.metadata.JoinType;
import cn.org.atool.fluent.mybatis.segment.BaseWrapper;
import cn.org.atool.fluent.mybatis.segment.BaseWrapperHelper;
import cn.org.atool.fluent.mybatis.segment.JoinOn;
import cn.org.atool.fluent.mybatis.segment.JoinWrapperData;
import cn.org.atool.fluent.mybatis.segment.WhereBase;
import cn.org.atool.fluent.mybatis.segment.model.PagedOffset;
import cn.org.atool.fluent.mybatis.segment.model.Parameters;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JoinQuery<QL extends BaseQuery<?, QL>>
implements IBaseQuery<IEntity, JoinQuery<QL>>,
JoinBuilder1<QL>,
JoinBuilder2<QL> {
    private final Class<QL> queryClass;
    private final QL query;
    private final List<BaseQuery> queries = new ArrayList<BaseQuery>();
    private final Parameters parameters = new Parameters();
    private JoinWrapperData wrapperData;
    private List<String> alias = new ArrayList<String>(8);
    private static Map<Class, Constructor> QueryAliasConstructors = new HashMap<Class, Constructor>(128);

    @Override
    public String[] getAlias() {
        return this.alias.toArray(new String[0]);
    }

    public JoinQuery(QL query) {
        this.assertQueryAlias((BaseQuery)query);
        this.query = query;
        ((BaseWrapper)this.query).setSharedParameter(this.parameters);
        this.queryClass = query.getClass();
        this.wrapperData = new JoinWrapperData((BaseQuery)this.query, this.queries, this.parameters);
        this.alias.add(((BaseQuery)this.query).tableAlias);
    }

    public JoinQuery(Class<QL> queryClass, QFunction<QL> query) {
        this.queryClass = queryClass;
        this.query = JoinQuery.newQuery(queryClass, Parameters.alias());
        ((BaseWrapper)this.query).setSharedParameter(this.parameters);
        query.apply(this.query);
        this.wrapperData = new JoinWrapperData((BaseQuery)this.query, this.queries, this.parameters);
        this.alias.add(((BaseQuery)this.query).tableAlias);
    }

    @Override
    public <QR extends BaseQuery<?, QR>> JoinOn<QL, QR, JoinBuilder2<QL>> join(Class<QR> clazz, QFunction<QR> query) {
        return this.join(JoinType.Join, clazz, query);
    }

    @Override
    public <QR extends BaseQuery<?, QR>> JoinOn<QL, QR, JoinBuilder2<QL>> leftJoin(Class<QR> clazz, QFunction<QR> query) {
        return this.join(JoinType.LeftJoin, clazz, query);
    }

    @Override
    public <QR extends BaseQuery<?, QR>> JoinOn<QL, QR, JoinBuilder2<QL>> rightJoin(Class<QR> clazz, QFunction<QR> query) {
        return this.join(JoinType.RightJoin, clazz, query);
    }

    @Override
    public <QR extends BaseQuery<?, QR>> JoinOn<QL, QR, JoinBuilder1<QL>> join(QR query) {
        return this.join(JoinType.Join, query);
    }

    @Override
    public <QR extends BaseQuery<?, QR>> JoinOn<QL, QR, JoinBuilder1<QL>> leftJoin(QR query) {
        return this.join(JoinType.LeftJoin, query);
    }

    @Override
    public <QR extends BaseQuery<?, QR>> JoinOn<QL, QR, JoinBuilder1<QL>> rightJoin(QR query) {
        return this.join(JoinType.RightJoin, query);
    }

    private <QR extends BaseQuery<?, QR>> JoinOn<QL, QR, JoinBuilder1<QL>> join(JoinType joinType, QR query) {
        this.assertQueryAlias(query);
        query.setSharedParameter((BaseWrapper)this.query);
        this.queries.add(query);
        this.alias.add(query.tableAlias);
        return new JoinOn(this, this.queryClass, this.query, joinType, query.getClass(), query);
    }

    private <QR extends BaseQuery<?, QR>> void assertQueryAlias(QR query) {
        MybatisUtil.assertNotNull("query", query);
        if (BaseWrapperHelper.isBlankAlias(query)) {
            String err = String.format("the alias in the join query table must be set, please use constructor: new %s(String alias, Parameters parameters)", query.getClass().getSimpleName());
            throw new RuntimeException(err);
        }
    }

    private <QR extends BaseQuery<?, QR>> JoinOn<QL, QR, JoinBuilder2<QL>> join(JoinType joinType, Class<QR> queryClass, QFunction<QR> apply) {
        QR query = JoinQuery.newQuery(queryClass, Parameters.alias());
        ((BaseWrapper)query).setSharedParameter(this.parameters);
        this.queries.add((BaseQuery)query);
        apply.apply(query);
        this.alias.add(((BaseQuery)query).tableAlias);
        return new JoinOn(this, this.queryClass, this.query, joinType, queryClass, query);
    }

    @Override
    public JoinBuilder<QL> select(String ... columns) {
        for (String column : columns) {
            this.wrapperData.addSelectColumn(column);
        }
        return this;
    }

    @Override
    public JoinQuery<QL> distinct() {
        this.wrapperData.setDistinct(true);
        return this;
    }

    @Override
    public JoinQuery<QL> limit(int limit) {
        this.wrapperData.setPaged(new PagedOffset(0, limit));
        return this;
    }

    @Override
    public JoinQuery<QL> limit(int start, int limit) {
        this.wrapperData.setPaged(new PagedOffset(start, limit));
        return this;
    }

    @Override
    public JoinQuery<QL> last(String lastSql) {
        this.wrapperData.last(lastSql);
        return this;
    }

    @Override
    public IQuery build() {
        return this;
    }

    @Override
    public JoinQuery<QL> selectAll() {
        throw new RuntimeException("not support");
    }

    @Override
    public JoinQuery<QL> selectId() {
        throw new RuntimeException("not support");
    }

    @Override
    public WhereBase<?, JoinQuery<QL>, JoinQuery<QL>> where() {
        throw new RuntimeException("not support");
    }

    private static <Q extends BaseQuery<?, Q>> Q newQuery(Class<Q> queryClass, String alias) {
        try {
            if (!QueryAliasConstructors.containsKey(queryClass)) {
                QueryAliasConstructors.put(queryClass, queryClass.getConstructor(String.class));
            }
            return (Q)((BaseQuery)QueryAliasConstructors.get(queryClass).newInstance(alias));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("new %s(String, ParameterPair) error: %s", queryClass.getSimpleName(), e.getMessage()), e);
        }
    }

    @Override
    public JoinWrapperData getWrapperData() {
        return this.wrapperData;
    }
}

