/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.base.crud.BaseQuery;
import cn.org.atool.fluent.mybatis.metadata.JoinType;
import cn.org.atool.fluent.mybatis.segment.WhereApply;
import cn.org.atool.fluent.mybatis.segment.where.BaseWhere;
import java.util.ArrayList;
import java.util.List;

public class JoinOnBuilder<QL extends BaseQuery<?, QL>, QR extends BaseQuery<?, QR>> {
    private BaseQuery queryLeft;
    private BaseQuery queryRight;
    private JoinType joinType;
    private List<String> ons = new ArrayList<String>();

    public JoinOnBuilder(BaseQuery queryLeft, JoinType joinType, BaseQuery queryRight) {
        this.queryLeft = queryLeft;
        this.queryRight = queryRight;
        this.joinType = joinType;
    }

    public JoinOnBuilder<QL, QR> on(BaseWhere left, BaseWhere right) {
        return this.on(((WhereApply)left).current().column, ((WhereApply)right).current().column);
    }

    public JoinOnBuilder on(String left, String right) {
        this.ons.add(String.format(this.queryLeft.appendAlias(left) + " = " + this.queryRight.appendAlias(right), new Object[0]));
        return this;
    }

    public String table() {
        String joinTable = String.format("%s %s", this.joinType.join(), this.queryRight.wrapperData.getTable());
        if (this.ons.isEmpty()) {
            return joinTable;
        }
        return joinTable + " ON " + String.join((CharSequence)" AND ", this.ons);
    }
}

