/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.base.crud.BaseQuery;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.splice.FreeQuery;
import cn.org.atool.fluent.mybatis.functions.OnConsumer;
import cn.org.atool.fluent.mybatis.metadata.JoinType;
import cn.org.atool.fluent.mybatis.segment.JoinOnBuilder;
import cn.org.atool.fluent.mybatis.segment.JoinQuery;
import cn.org.atool.fluent.mybatis.segment.where.BaseWhere;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class JoinOn<QL extends BaseQuery<?, QL>, QR extends BaseQuery<?, QR>, JB> {
    private JoinQuery<QL> joinQuery;
    private QL onLeft;
    private QR onRight;
    private JoinOnBuilder onBuilder;
    private static Map<Class, Constructor> QueryNoArgConstructors = new HashMap<Class, Constructor>(128);

    public JoinOn(JoinQuery<QL> joinQuery, Class<QL> qLeftClass, QL qLeft, JoinType joinType, Class<QR> qRightClass, QR qRight) {
        this.joinQuery = joinQuery;
        this.onBuilder = new JoinOnBuilder((BaseQuery)qLeft, joinType, (BaseQuery)qRight);
        this.onLeft = qLeft instanceof FreeQuery ? ((FreeQuery)qLeft).emptyQuery() : JoinOn.newEmptyQuery(qLeftClass);
        this.onRight = qRight instanceof FreeQuery ? ((FreeQuery)qRight).emptyQuery() : JoinOn.newEmptyQuery(qRightClass);
    }

    public JB on(OnConsumer<QL, QR> join) {
        join.accept(this.onBuilder, this.onLeft, this.onRight);
        this.joinQuery.getWrapperData().addTable(this.onBuilder.table());
        return (JB)this.joinQuery;
    }

    public JB on(String condition) {
        this.joinQuery.getWrapperData().addTable(this.onBuilder.table() + " ON " + condition);
        return (JB)this.joinQuery;
    }

    public JoinOn<QL, QR, JB> on(Function<QL, BaseWhere> l, Function<QR, BaseWhere> r) {
        this.onBuilder.on(l.apply(this.onLeft), r.apply(this.onRight));
        return this;
    }

    public JoinOn<QL, QR, JB> on(String l, String r) {
        this.onBuilder.on(l, r);
        return this;
    }

    public JoinOn<QL, QR, JB> on(FieldMapping l, FieldMapping r) {
        this.onBuilder.on(l.column, r.column);
        return this;
    }

    public JB endJoin() {
        this.joinQuery.getWrapperData().addTable(this.onBuilder.table());
        return (JB)this.joinQuery;
    }

    private static <Q extends BaseQuery<?, Q>> Q newEmptyQuery(Class<Q> klass) {
        try {
            if (!QueryNoArgConstructors.containsKey(klass)) {
                QueryNoArgConstructors.put(klass, klass.getConstructor(new Class[0]));
            }
            return (Q)((BaseQuery)QueryNoArgConstructors.get(klass).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("new %s() error: %s", klass.getSimpleName(), e.getMessage()), e);
        }
    }
}

