/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.segment;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.IBaseQuery;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.metadata.TableMeta;
import cn.org.atool.fluent.mybatis.metadata.TableMetaHelper;
import cn.org.atool.fluent.mybatis.segment.model.Parameters;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.util.List;
import java.util.function.Supplier;

public abstract class BaseWrapper<E extends IEntity, W extends IWrapper<E, W, NQ>, NQ extends IBaseQuery<E, NQ>>
implements IWrapper<E, W, NQ> {
    private static final long serialVersionUID = 2674302532927710150L;
    protected Supplier<String> table;
    protected final String tableAlias;
    protected final WrapperData wrapperData;

    protected BaseWrapper(Supplier<String> table, String tableAlias, Class<E> entityClass, Class queryClass) {
        this(table, tableAlias, new Parameters(), entityClass, queryClass);
    }

    protected BaseWrapper(Supplier<String> table, String tableAlias, Parameters parameters, Class<E> entityClass, Class queryClass) {
        MybatisUtil.notNull(entityClass, "entityClass must not null,please set entity before use this method!", new Object[0]);
        this.table = table;
        this.tableAlias = If.isBlank(tableAlias) ? "" : tableAlias.trim();
        this.wrapperData = new WrapperData(table, this.tableAlias, parameters, entityClass, queryClass);
    }

    public String primary() {
        return null;
    }

    protected void validateColumn(String column) throws FluentMybatisException {
        if (If.notBlank(column) && !this.allFields().contains(column)) {
            throw new FluentMybatisException("the column[" + column + "] was not found in table[" + this.wrapperData.getTable() + "].");
        }
    }

    protected abstract List<String> allFields();

    protected TableMeta getTableMeta() {
        return TableMetaHelper.getTableInfo(this.getWrapperData().getEntityClass());
    }

    protected String appendAlias(String column) {
        if (If.notBlank(this.tableAlias) && MybatisUtil.isColumnName(column)) {
            return this.tableAlias + "." + column;
        }
        return column;
    }

    protected void setSharedParameter(Parameters parameters) {
        this.wrapperData.getParameters().setSharedParameter(parameters);
    }

    protected void setSharedParameter(BaseWrapper wrapper) {
        this.wrapperData.getParameters().setSharedParameter(wrapper.getWrapperData().getParameters());
    }

    public Supplier<String> getTable() {
        return this.table;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public WrapperData getWrapperData() {
        return this.wrapperData;
    }
}

