/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.model;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.model.SqlOpStr;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.io.Serializable;
import java.util.Arrays;

public class FormItem
implements Serializable {
    private static final long serialVersionUID = 5691660056854381559L;
    private String key;
    private String op;
    private Object[] value;

    public FormItem() {
    }

    public FormItem(String key, String op, Object ... value) {
        this.key = key;
        this.op = op;
        this.value = value;
        this.validate();
    }

    private void validate() {
        MybatisUtil.assertNotBlank("key", this.key);
        if (If.isBlank(this.op)) {
            this.op = SqlOpStr.OP_EQ;
        } else if (!SqlOpStr.ALL_OP.contains(this.op)) {
            throw new RuntimeException("only support operation:" + String.join((CharSequence)", ", SqlOpStr.ALL_OP) + ", but find:" + this.op);
        }
        if (SqlOpStr.OP_BETWEEN.equals(this.op) || SqlOpStr.OP_NOT_BETWEEN.equals(this.op)) {
            MybatisUtil.assertNotEmpty("value", this.value);
            if (this.value.length != 2) {
                throw new RuntimeException("The number of between operation parameters[" + this.key + "] must be two.");
            }
        } else if (SqlOpStr.OP_IN.equals(this.op) || SqlOpStr.OP_NOT_IN.equals(this.op)) {
            MybatisUtil.assertNotEmpty("parameter of " + this.key, this.value);
        } else if (!SqlOpStr.OP_IS_NULL.equals(this.op) && !SqlOpStr.OP_NOT_NULL.equals(this.op)) {
            MybatisUtil.assertNotEmpty("parameter of " + this.key, this.value);
            if (this.value.length != 1) {
                throw new RuntimeException("The number of parameters[" + this.key + "] must be one.");
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getOp() {
        return this.op;
    }

    public Object[] getValue() {
        return this.value;
    }

    public FormItem setKey(String key) {
        this.key = key;
        return this;
    }

    public FormItem setOp(String op) {
        this.op = op;
        return this;
    }

    public FormItem setValue(Object[] value) {
        this.value = value;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FormItem)) {
            return false;
        }
        FormItem other = (FormItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$op = this.getOp();
        String other$op = other.getOp();
        if (this$op == null ? other$op != null : !this$op.equals(other$op)) {
            return false;
        }
        return Arrays.deepEquals(this.getValue(), other.getValue());
    }

    protected boolean canEqual(Object other) {
        return other instanceof FormItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $op = this.getOp();
        result = result * 59 + ($op == null ? 43 : $op.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getValue());
        return result;
    }

    public String toString() {
        return "FormItem(key=" + this.getKey() + ", op=" + this.getOp() + ", value=" + Arrays.deepToString(this.getValue()) + ")";
    }
}

