/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.metadata;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.lang.reflect.Field;
import org.apache.ibatis.type.JdbcType;

public abstract class FieldMeta
implements Comparable<FieldMeta> {
    protected final String column;
    protected final String property;
    protected final Class<?> propertyType;
    private JdbcType jdbcType;

    public FieldMeta(String column, Field field) {
        this.property = field.getName();
        this.column = If.isBlank(column) ? MybatisUtil.camelToUnderline(this.property, false) : column;
        this.propertyType = field.getType();
    }

    public void setJdbcType(JdbcType jdbcType) {
        this.jdbcType = JdbcType.UNDEFINED == jdbcType ? null : jdbcType;
    }

    public String el() {
        String el = this.property;
        if (this.jdbcType != null) {
            el = el + ", jdbcType = " + this.jdbcType.name();
        }
        return el;
    }

    public boolean isNotLarge() {
        return true;
    }

    @Override
    public int compareTo(FieldMeta info) {
        return this.column.compareTo(info == null ? null : info.getColumn());
    }

    public String getColumn() {
        return this.column;
    }

    public String getProperty() {
        return this.property;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }
}

