/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.model;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.segment.model.Parameters;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SqlOp {
    IS_NULL("IS NULL", 0),
    NOT_NULL("IS NOT NULL", 0),
    EQ("= ?", "= %s", 1),
    NE("<> ?", "<> %s", 1),
    GT("> ?", "> %s", 1),
    GE(">= ?", ">= %s", 1),
    LT("< ?", "< %s", 1),
    LE("<= ?", "<= %s", 1),
    BETWEEN("BETWEEN ? AND ?", "BETWEEN %s", 2),
    NOT_BETWEEN("NOT BETWEEN ? AND ?", "NOT BETWEEN %s", 2),
    LIKE("LIKE ?", "LIKE %s", 1),
    NOT_LIKE("NOT LIKE ?", "NOT LIKE %s", 1),
    IN("IN (%s)", -1),
    NOT_IN("NOT IN (%s)", -1),
    EXISTS("EXISTS (%s)", -1),
    NOT_EXISTS("NOT EXISTS (%s)", -1),
    BRACKET("( %s )", -1),
    RETAIN("%s", -1);

    private final String placeHolder;
    private final String format;
    private final int argSize;

    private SqlOp(String placeHolder, int argSize) {
        this.placeHolder = placeHolder;
        this.format = placeHolder;
        this.argSize = argSize;
    }

    private SqlOp(String placeHolder, String format, int argSize) {
        this.placeHolder = placeHolder;
        this.format = format;
        this.argSize = argSize;
    }

    public String operator(Parameters parameters, String expression, Object ... paras) {
        String sql = this.placeHolder;
        if (If.notBlank(expression)) {
            sql = String.format(this.format, expression);
        } else if (this.placeHolder.contains("%s")) {
            sql = this.setPlaceHolder(paras);
        }
        return If.isEmpty(paras) ? sql : parameters.paramSql(sql, paras);
    }

    private String setPlaceHolder(Object ... values) {
        String placeHolder = "";
        if (values.length == 1 && values[0] instanceof Collection) {
            Collection list = (Collection)values[0];
            placeHolder = list.stream().map(v -> "?").collect(Collectors.joining(", "));
        } else {
            placeHolder = Stream.of(values).map(v -> "?").collect(Collectors.joining(", "));
        }
        return String.format(this.placeHolder, placeHolder);
    }

    public int getArgSize() {
        return this.argSize;
    }
}

