/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base.crud;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.crud.BatchCrudImpl;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.crud.IWrapper;
import cn.org.atool.fluent.mybatis.base.model.InsertList;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.mapper.MapperSql;
import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.fluent.mybatis.segment.model.WrapperData;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.fluent.mybatis.utility.SqlProviderUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class BaseSqlProvider<E extends IEntity> {
    private static final char[] EW_CONST = "#{ew.".toCharArray();
    private static final String sub = ".wrapperData.parameters.";

    public static String batchCrud(Map map) {
        IWrapper wrapper = SqlProviderUtils.getWrapper(map, "ew");
        if (!(wrapper instanceof BatchCrudImpl)) {
            throw new IllegalArgumentException("the wrapper should be an instance of BatchUpdaterImpl.");
        }
        return ((BatchCrudImpl)wrapper).batchSql();
    }

    public String insertSelect(Map map) {
        String[] fields = (String[])map.get("fields");
        IQuery query = (IQuery)map.get("ew");
        return BaseSqlProvider.buildInsertSelect(this.tableName(), fields, query);
    }

    public static String buildInsertSelect(String tableName, String[] fields, IQuery query) {
        MybatisUtil.assertNotBlank("tableName", tableName);
        MybatisUtil.assertNotEmpty("fields", fields);
        MybatisUtil.assertNotNull("ew", query);
        StringBuilder buff = new StringBuilder("INSERT INTO ").append(tableName).append(" (").append(String.join((CharSequence)",", fields)).append(") ").append(query.getWrapperData().getQuerySql());
        return buff.toString();
    }

    public String insert(E entity) {
        return this.buildInsertSql("", entity, false);
    }

    public String insertWithPk(E entity) {
        return this.buildInsertSql("", entity, true);
    }

    public String insertBatch(Map map) {
        MybatisUtil.assertNotEmpty("list", map);
        List entities = (List)SqlProviderUtils.getParas(map, "list");
        return this.insertBatch(entities, false);
    }

    public String insertBatchWithPk(Map map) {
        MybatisUtil.assertNotEmpty("list", map);
        List entities = (List)SqlProviderUtils.getParas(map, "list");
        return this.insertBatch(entities, true);
    }

    private String insertBatch(List<E> entities, boolean withPk) {
        MapperSql sql = new MapperSql();
        for (IEntity entity : entities) {
            this.validateInsertEntity(entity, withPk);
        }
        sql.INSERT_INTO(this.tableName());
        sql.INSERT_COLUMNS(this.allFields(withPk));
        sql.VALUES();
        for (int index = 0; index < entities.size(); ++index) {
            if (index > 0) {
                sql.APPEND(", ");
            }
            sql.INSERT_COLUMNS(this.insertBatchEntity(index, (IEntity)entities.get(index), withPk));
        }
        return sql.toString();
    }

    private void validateInsertEntity(E entity, boolean withPk) {
        this.setEntityByDefault((IEntity)entity);
        if (withPk) {
            MybatisUtil.isTrue(this.primaryNotNull(entity), "the pk of insert entity can't be null.", new Object[0]);
        } else {
            MybatisUtil.isTrue(this.primaryIsNull(entity), "the pk of insert entity must be null.", new Object[0]);
        }
    }

    protected abstract void insertEntity(InsertList var1, String var2, E var3, boolean var4);

    protected abstract List<String> insertBatchEntity(int var1, E var2, boolean var3);

    protected abstract boolean primaryIsNull(E var1);

    protected abstract boolean primaryNotNull(E var1);

    public String countNoLimit(Map map) {
        WrapperData data = SqlProviderUtils.getWrapperData(map, "ew");
        MapperSql sql = new MapperSql();
        sql.COUNT(data.getTable(), data);
        sql.WHERE_GROUP_BY(data);
        return sql.toString();
    }

    public String count(Map map) {
        WrapperData data = SqlProviderUtils.getWrapperData(map, "ew");
        MapperSql sql = new MapperSql();
        sql.COUNT(data.getTable(), data);
        sql.WHERE_GROUP_ORDER_BY(data);
        return SqlProviderUtils.byPaged(this.dbType(), data, sql.toString());
    }

    public String listEntity(Map map) {
        WrapperData data = SqlProviderUtils.getWrapperData(map, "ew");
        MapperSql sql = new MapperSql();
        sql.SELECT(data.getTable(), data, this.allFields(true));
        sql.WHERE_GROUP_ORDER_BY(data);
        return SqlProviderUtils.byPaged(this.dbType(), data, sql.toString());
    }

    public String listMaps(Map map) {
        WrapperData data = SqlProviderUtils.getWrapperData(map, "ew");
        MapperSql sql = new MapperSql();
        sql.SELECT(data.getTable(), data, this.allFields(true));
        sql.WHERE_GROUP_ORDER_BY(data);
        return SqlProviderUtils.byPaged(this.dbType(), data, sql.toString());
    }

    public String listObjs(Map map) {
        WrapperData data = SqlProviderUtils.getWrapperData(map, "ew");
        MapperSql sql = new MapperSql();
        sql.SELECT(data.getTable(), data, this.allFields(true));
        sql.WHERE_GROUP_ORDER_BY(data);
        return SqlProviderUtils.byPaged(this.dbType(), data, sql.toString());
    }

    public String listByMap(Map map) {
        Map where = (Map)SqlProviderUtils.getParas(map, "cm");
        MybatisUtil.assertNotEmpty("where", where);
        MapperSql sql = new MapperSql();
        sql.SELECT(this.tableName(), this.allFields(true));
        sql.WHERE("cm", where);
        return sql.toString();
    }

    public String listByIds(Map map) {
        MapperSql sql = new MapperSql();
        Collection ids = (Collection)SqlProviderUtils.getParas(map, "coll");
        MybatisUtil.assertNotEmpty("PrimaryKeyList", ids);
        sql.SELECT(this.tableName(), this.allFields(true));
        sql.WHERE_PK_IN(this.idColumn(), ids.size());
        return sql.toString();
    }

    public String findById(Serializable id) {
        MybatisUtil.assertNotNull("PrimaryKey", id);
        MapperSql sql = new MapperSql();
        sql.SELECT(this.tableName(), this.allFields(true));
        sql.WHERE(String.format("%s = #{value}", this.idColumn()));
        return sql.toString();
    }

    public String findOne(Map map) {
        WrapperData data = SqlProviderUtils.getWrapperData(map, "ew");
        MapperSql sql = new MapperSql();
        sql.SELECT(data.getTable(), data, this.allFields(true));
        sql.WHERE_GROUP_ORDER_BY(data);
        return SqlProviderUtils.byPaged(this.dbType(), data, sql.toString());
    }

    public String deleteById(Serializable id) {
        MybatisUtil.assertNotNull("PrimaryKey", id);
        MapperSql sql = new MapperSql();
        sql.DELETE_FROM(this.tableName(), null);
        sql.WHERE(String.format("%s = #{value}", this.idColumn()));
        return sql.toString();
    }

    public String deleteByIds(Map map) {
        Collection ids = (Collection)SqlProviderUtils.getParas(map, "coll");
        MybatisUtil.assertNotEmpty("PrimaryKeyList", ids);
        MapperSql sql = new MapperSql();
        sql.DELETE_FROM(this.tableName(), null);
        sql.WHERE_PK_IN(this.idColumn(), ids.size());
        return sql.toString();
    }

    public String deleteByMap(Map<String, Object> map) {
        Map cm = (Map)SqlProviderUtils.getParas(map, "cm");
        MapperSql sql = new MapperSql();
        sql.DELETE_FROM(this.tableName(), null);
        ArrayList<String> where = new ArrayList<String>();
        for (String key : cm.keySet()) {
            where.add(String.format("%s = #{%s.%s}", key, "cm", key));
        }
        sql.WHERE(where);
        return sql.toString();
    }

    public String delete(Map map) {
        WrapperData data = SqlProviderUtils.getWrapperData(map, "ew");
        return this.buildDeleteSql(data);
    }

    public String updateBy(Map<String, Object> map) {
        Object wrapper = map.get("ew");
        if (If.isEmpty(wrapper)) {
            throw FluentMybatisException.instance("the parameter[%s] can't be empty.", "ew");
        }
        if (!(wrapper instanceof IUpdate[])) {
            throw new IllegalArgumentException("the parameter should be an array of IUpdate");
        }
        IUpdate[] updaters = (IUpdate[])wrapper;
        ArrayList<String> list = new ArrayList<String>(updaters.length);
        int index = 0;
        for (IUpdate updater : updaters) {
            String sql = this.buildUpdaterSql(updater.getWrapperData());
            sql = BaseSqlProvider.addEwParaIndex(sql, String.format("[%d]", index));
            ++index;
            list.add(sql);
        }
        String text = list.stream().collect(Collectors.joining(";\n"));
        return text;
    }

    static String addEwParaIndex(String sql, String aIndex) {
        StringBuilder buff = new StringBuilder();
        int match = 0;
        int len = sql.length();
        for (int loop = 0; loop < sql.length(); ++loop) {
            char ch = sql.charAt(loop);
            if (match == 4) {
                if (sql.substring(loop, Integer.min(sub.length() + loop, len)).equals(sub)) {
                    buff.append(aIndex);
                }
                match = 0;
            } else {
                match = EW_CONST[match] == ch ? match + 1 : 0;
            }
            buff.append(ch);
        }
        return buff.toString();
    }

    protected abstract void setEntityByDefault(IEntity var1);

    protected abstract List<String> updateDefaults(Map<String, String> var1);

    protected abstract String tableName();

    protected abstract String idColumn();

    protected abstract String allFields(boolean var1);

    protected abstract DbType dbType();

    public String buildInsertSql(String prefix, E entity, boolean withPk) {
        MybatisUtil.assertNotNull("entity", entity);
        this.validateInsertEntity(entity, withPk);
        MapperSql sql = new MapperSql();
        sql.INSERT_INTO(this.tableName());
        InsertList inserts = new InsertList();
        this.insertEntity(inserts, prefix, entity, withPk);
        sql.INSERT_COLUMNS(inserts.columns);
        sql.VALUES();
        sql.INSERT_VALUES(inserts.values);
        return sql.toString();
    }

    public String buildUpdaterSql(WrapperData data) {
        MybatisUtil.assertNotNull("wrapperData of updater", data);
        Map<String, String> updates = data.getUpdates();
        MybatisUtil.assertNotEmpty("updates", updates);
        MapperSql sql = new MapperSql();
        sql.UPDATE(data.getTable(), data);
        List<String> sets = this.updateDefaults(updates);
        sets.add(data.getUpdateStr());
        sql.SET(sets);
        sql.WHERE_GROUP_ORDER_BY(data);
        sql.LIMIT(data, true);
        return sql.toString();
    }

    public String buildDeleteSql(WrapperData data) {
        MapperSql sql = new MapperSql();
        sql.DELETE_FROM(this.tableName(), data);
        sql.WHERE_GROUP_ORDER_BY(data);
        return sql.toString();
    }
}

