/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.RichEntity;
import cn.org.atool.fluent.mybatis.base.crud.IQuery;
import cn.org.atool.fluent.mybatis.base.crud.IUpdate;
import cn.org.atool.fluent.mybatis.base.entity.IEntityHelper;
import cn.org.atool.fluent.mybatis.base.mapper.IRichMapper;
import cn.org.atool.fluent.mybatis.mapper.EntityHelperFactory;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class IRefs
implements ApplicationContextAware,
InitializingBean {
    private static IRefs INSTANCE;
    private Map<String, Method> refMethods = new ConcurrentHashMap<String, Method>(32);
    protected ApplicationContext applicationContext;

    public static IEntityHelper findEntityHelper(Class clazz) {
        return EntityHelperFactory.getInstance(clazz);
    }

    public static IRefs instance() {
        if (INSTANCE == null) {
            throw IRefs.springNotInitException();
        }
        return INSTANCE;
    }

    protected static RuntimeException springNotInitException() {
        return new RuntimeException("the Refs must be defined as a spring bean.");
    }

    public abstract IQuery defaultQuery(Class<? extends IEntity> var1);

    public abstract IQuery emptyQuery(Class<? extends IEntity> var1);

    public abstract IUpdate defaultUpdater(Class<? extends IEntity> var1);

    public abstract IUpdate emptyUpdater(Class<? extends IEntity> var1);

    public abstract String findColumnByField(Class var1, String var2);

    public abstract String findPrimaryColumn(Class var1);

    public <T> T invoke(Class entityClass, String methodName, Object[] args) {
        IEntity entity = (IEntity)args[0];
        String methodOfEntity = MybatisUtil.methodNameOfEntity(methodName, this.findFluentEntityClass(entityClass));
        switch (methodName) {
            case "save": {
                IRefs.mapper(entity).save(entity);
                return (T)entity;
            }
            case "updateById": {
                IRefs.mapper(entity).updateById(entity);
                return (T)entity;
            }
            case "findById": {
                Object result = IRefs.mapper(entity).findById(entity.findPk());
                return (T)result;
            }
            case "deleteById": {
                IRefs.mapper(entity).deleteById(entity.findPk());
                return null;
            }
            case "listByNotNull": {
                Map<String, Object> where = entity.toColumnMap();
                MybatisUtil.assertNotEmpty("the property of entity can't be all empty.", where);
                List list = IRefs.mapper(entity).listByMap(where);
                return (T)list;
            }
        }
        return this.invokeRefMethod(methodOfEntity, args);
    }

    private <T> T invokeRefMethod(String methodOfEntity, Object[] args) {
        if (!this.refMethods.containsKey(methodOfEntity)) {
            throw new RuntimeException("the method[" + methodOfEntity + "] not defined or wrong define.");
        }
        Method method = this.refMethods.get(methodOfEntity);
        try {
            return (T)method.invoke((Object)this, args);
        }
        catch (Exception e) {
            String err = String.format("invoke method[%s] error:%s", methodOfEntity, e.getMessage());
            throw new RuntimeException(err, e);
        }
    }

    public Class<? extends IEntity> findFluentEntityClass(Class clazz) {
        Set<Class<? extends IEntity>> all = this.allEntityClass();
        if (all.isEmpty()) {
            throw new RuntimeException("the sub of IRefs must be a spring bean.");
        }
        for (Class entity = clazz; entity != Object.class; entity = entity.getSuperclass()) {
            if (!all.contains(entity)) continue;
            return entity;
        }
        throw new RuntimeException("the class[" + clazz.getName() + "] is not a @FluentMybatis Entity.");
    }

    protected abstract Set<Class<? extends IEntity>> allEntityClass();

    public static IRichMapper mapper(IEntity entity) {
        IRefs.instance();
        return IRefs.mapper(entity.getClass());
    }

    public static IRichMapper mapper(Class<? extends IEntity> clazz) {
        return IRefs.instance().getMapper(clazz);
    }

    protected abstract IRichMapper getMapper(Class<? extends IEntity> var1);

    public void afterPropertiesSet() throws Exception {
        Method[] methods;
        for (Method method : methods = this.getClass().getMethods()) {
            Class<?> parameterType;
            if (method.getParameterCount() == 0 || !RichEntity.class.isAssignableFrom(parameterType = method.getParameterTypes()[0])) continue;
            this.refMethods.put(method.getName(), method);
        }
        this.initEntityMapper();
        INSTANCE = this;
    }

    protected abstract void initEntityMapper();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

