/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.base;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.mapper.IRichMapper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface IBaseDao<E extends IEntity> {
    default public <PK extends Serializable> PK save(E entity) {
        Object pk = this.mapper().save(entity);
        return pk;
    }

    default public int save(Collection<E> list) {
        int count = this.mapper().save(list);
        return count;
    }

    default public boolean saveOrUpdate(E entity) {
        return this.mapper().saveOrUpdate(entity);
    }

    default public E selectById(Serializable id) {
        Object obj = this.mapper().findById(id);
        return (E)((IEntity)obj);
    }

    default public List<E> selectByIds(Serializable ... ids) {
        List list = this.mapper().listByIds(Arrays.asList(ids));
        return list;
    }

    default public List<E> selectByIds(Collection<? extends Serializable> ids) {
        List list = this.mapper().listByIds(ids);
        return list;
    }

    default public List<E> selectByMap(Map<String, Object> where) {
        List list = this.mapper().listByMapAndDefault(where);
        return list;
    }

    default public boolean existPk(Serializable id) {
        return this.mapper().existPk(id);
    }

    default public boolean updateById(E entity) {
        return this.mapper().updateById(entity) > 0;
    }

    public boolean updateEntityByIds(E ... var1);

    default public boolean updateEntityByIds(Collection<E> entities) {
        return this.updateEntityByIds(entities.toArray(new IEntity[0]));
    }

    public int updateBy(E var1, E var2);

    default public int deleteByEntityIds(Collection<E> entities) {
        int count = this.mapper().deleteByEntityIds(entities);
        return count;
    }

    default public int deleteByEntityIds(E ... entities) {
        int count = this.mapper().deleteByEntityIds((IEntity[])entities);
        return count;
    }

    default public int deleteByIds(Collection<? extends Serializable> ids) {
        int count = this.mapper().deleteByIds(ids);
        return count;
    }

    default public boolean deleteById(Serializable ... ids) {
        int count;
        if (ids.length == 1) {
            count = this.mapper().deleteById(ids[0]);
        } else {
            List<Serializable> list = Arrays.asList(ids);
            count = this.mapper().deleteByIds(list);
        }
        return count > 0;
    }

    default public int deleteByMap(Map<String, Object> map) {
        int count = this.mapper().deleteByMapAndDefault(map);
        return count;
    }

    public IRichMapper mapper();
}

