/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.test.util;

import cn.org.atool.fluent.mybatis.utility.SqlInject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.test4j.junit5.Test4J;
import org.test4j.tools.datagen.DataProvider;

public class SqlInjectTest
extends Test4J {
    @MethodSource(value={"data_isKeyword"})
    @ParameterizedTest
    public void test_isKeyword(String string, boolean isKeyword) {
        boolean result = SqlInject.probablySqlInject((String)string);
        want.bool(Boolean.valueOf(result)).is(isKeyword);
    }

    public static DataProvider data_isKeyword() {
        return new DataProvider().data(new Object[]{"and", true}).data(new Object[]{"vand", false}).data(new Object[]{"ande", false}).data(new Object[]{" and", true}).data(new Object[]{"\tand ", true}).data(new Object[]{"ANd", true}).data(new Object[]{"adfasdf and afdasf", true}).data(new Object[]{"adfad grAnt dafd", true}).data(new Object[]{"adfad GRANT\ndafd", true}).data(new Object[]{"adfad GRANT", true}).data(new Object[]{"GRANt dddd", true}).data(new Object[]{"adfad GRAN", false}).data(new Object[]{"adfad grAnt_", false});
    }

    @MethodSource(value={"data_isDanger"})
    @ParameterizedTest
    public void test_isDanger(String string, boolean isKeyword) {
        boolean result = SqlInject.probablySqlInject((String)string);
        want.bool(Boolean.valueOf(result)).is(isKeyword);
    }

    public static DataProvider data_isDanger() {
        return new DataProvider().data(new Object[]{"--", true}).data(new Object[]{"-", false}).data(new Object[]{"aaa--bbb", true}).data(new Object[]{"aaa-d-bbb", false}).data(new Object[]{"aaa#bbb", true}).data(new Object[]{"aaa%bbb", true}).data(new Object[]{"aaa/bbb", true}).data(new Object[]{"aaa'bbb", true}).data(new Object[]{"aaa\\bbb", true}).data(new Object[]{"aaa*bbb", true});
    }

    @MethodSource(value={"data_simpleNoInject"})
    @ParameterizedTest
    public void test_simpleNoInject(String string, boolean isKeyword) {
        boolean result = SqlInject.hasSimpleInject((String)string);
        want.bool(Boolean.valueOf(result)).is(isKeyword);
    }

    public static DataProvider data_simpleNoInject() {
        return new DataProvider().data(new Object[]{"--", true}).data(new Object[]{"---aaa", true}).data(new Object[]{"and", false}).data(new Object[]{"-", false}).data(new Object[]{"aaa--bbb", true}).data(new Object[]{"aaa-d-bbb", false}).data(new Object[]{"aaa#bbb", true}).data(new Object[]{"aaa%bbb", true}).data(new Object[]{"aaa/bbb", true}).data(new Object[]{"aaa'bbb", true}).data(new Object[]{"aaa\\bbb", true}).data(new Object[]{"aaa*bbb", true});
    }

    @Test
    public void test_assertSimpleNoInject() {
        Assertions.assertThrows(RuntimeException.class, () -> SqlInject.assertSimpleNoInject((String)"test", (String)"--"));
    }

    @Test
    public void test_assertNoInject() {
        Assertions.assertThrows(RuntimeException.class, () -> SqlInject.assertNoInject((String)"test", (String)"and"));
    }
}

