/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.test.method;

import cn.org.atool.fluent.mybatis.base.IQuery;
import cn.org.atool.fluent.mybatis.demo.generate.datamap.TM;
import cn.org.atool.fluent.mybatis.demo.generate.datamap.table.UserTableMap;
import cn.org.atool.fluent.mybatis.demo.generate.helper.UserWrapperHelper;
import cn.org.atool.fluent.mybatis.demo.generate.mapper.UserMapper;
import cn.org.atool.fluent.mybatis.demo.generate.wrapper.UserQuery;
import cn.org.atool.fluent.mybatis.method.model.XmlConstant;
import cn.org.atool.fluent.mybatis.segment.WhereApply;
import cn.org.atool.fluent.mybatis.test.BaseTest;
import java.io.Serializable;
import org.junit.jupiter.api.Test;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.beans.factory.annotation.Autowired;
import org.test4j.function.SExecutor;
import org.test4j.hamcrest.iassert.intf.IStringAssert;
import org.test4j.hamcrest.matcher.string.StringMode;
import org.test4j.tools.datagen.IDataMap;

public class SelectCountTest
extends BaseTest {
    @Autowired
    private UserMapper mapper;

    @Test
    public void test_selectCount_null() throws Exception {
        ((IStringAssert)want.exception((SExecutor & Serializable)() -> this.mapper.count(null), new Class[]{MyBatisSystemException.class}).contains("Error evaluating expression", new StringMode[0])).contains(XmlConstant.Wrapper_Exists, new StringMode[0]);
    }

    @Test
    public void test_selectCount() throws Exception {
        db.table("t_user").clean().insert(new IDataMap[]{((UserTableMap)TM.user.createWithInit((int)4).id.values((Object)Integer.valueOf((int)23), (Object[])new Object[]{Integer.valueOf((int)24), Integer.valueOf((int)25), Integer.valueOf((int)26)})).user_name.values((Object)"u1", new Object[]{"u2", "u3", "u2"})});
        UserQuery query = (UserQuery)((UserWrapperHelper.QueryWhere)((WhereApply)new UserQuery().where.id()).eq((Object)24L)).end();
        int count = this.mapper.count((IQuery)query);
        ((IStringAssert)db.sqlList().wantFirstSql().start("SELECT COUNT( * )", new StringMode[0])).end("FROM t_user WHERE id = ?", new StringMode[0]);
        want.number(Integer.valueOf(count)).eq((Object)1);
    }

    @Test
    public void test_selectCount_hasMultiple() throws Exception {
        db.table("t_user").clean().insert(new IDataMap[]{((UserTableMap)TM.user.createWithInit((int)4).id.values((Object)Integer.valueOf((int)23), (Object[])new Object[]{Integer.valueOf((int)24), Integer.valueOf((int)25), Integer.valueOf((int)26)})).user_name.values((Object)"u1", new Object[]{"u2", "u3", "u2"})});
        UserQuery query = (UserQuery)((UserWrapperHelper.QueryWhere)((WhereApply)((UserQuery)((UserWrapperHelper.Selector)new UserQuery().select.apply((String[])new String[]{"id"})).end()).where.userName()).eq((Object)"u2")).end();
        int count = this.mapper.count((IQuery)query);
        ((IStringAssert)db.sqlList().wantFirstSql().start("SELECT COUNT( id )", new StringMode[0])).end("FROM t_user WHERE user_name = ?", new StringMode[0]);
        want.number(Integer.valueOf(count)).eq((Object)2);
    }

    @Test
    public void test_selectCount_limit() throws Exception {
        db.table("t_user").clean().insert(new IDataMap[]{((UserTableMap)TM.user.createWithInit((int)4).id.values((Object)Integer.valueOf((int)23), (Object[])new Object[]{Integer.valueOf((int)24), Integer.valueOf((int)25), Integer.valueOf((int)26)})).user_name.values((Object)"u1", new Object[]{"u2", "u3", "u2"})});
        UserQuery query = (UserQuery)((UserQuery)((UserWrapperHelper.QueryWhere)((WhereApply)((UserQuery)((UserWrapperHelper.Selector)new UserQuery().select.apply((String[])new String[]{"id"})).end()).where.userName()).eq((Object)"u2")).end()).limit(2);
        int count = this.mapper.count((IQuery)query);
        ((IStringAssert)db.sqlList().wantFirstSql().start("SELECT COUNT( id )", new StringMode[0])).end("FROM t_user WHERE user_name = ? LIMIT ?, ?", new StringMode[0]);
        want.number(Integer.valueOf(count)).eq((Object)2);
    }
}

