/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.test.method;

import cn.org.atool.fluent.mybatis.demo.generate.datamap.TM;
import cn.org.atool.fluent.mybatis.demo.generate.datamap.table.NoAutoIdTableMap;
import cn.org.atool.fluent.mybatis.demo.generate.datamap.table.NoPrimaryTableMap;
import cn.org.atool.fluent.mybatis.demo.generate.datamap.table.UserTableMap;
import cn.org.atool.fluent.mybatis.demo.generate.entity.NoAutoIdEntity;
import cn.org.atool.fluent.mybatis.demo.generate.entity.NoPrimaryEntity;
import cn.org.atool.fluent.mybatis.demo.generate.entity.UserEntity;
import cn.org.atool.fluent.mybatis.demo.generate.mapper.NoAutoIdMapper;
import cn.org.atool.fluent.mybatis.demo.generate.mapper.NoPrimaryMapper;
import cn.org.atool.fluent.mybatis.demo.generate.mapper.UserMapper;
import cn.org.atool.fluent.mybatis.test.BaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.test4j.hamcrest.matcher.modes.EqMode;
import org.test4j.tools.datagen.IDataMap;

public class InsertTest
extends BaseTest {
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private NoAutoIdMapper idMapper;
    @Autowired
    private NoPrimaryMapper noPrimaryMapper;

    @Test
    public void testInsert() {
        db.table("t_user").clean();
        UserEntity user = new UserEntity().setAge(23).setUserName("tom mike");
        this.userMapper.insert(user);
        user.setId(null);
        this.userMapper.insert(user);
        want.number(user.getId()).isGt((Object)1L);
        db.table("t_user").query().eqDataMap(((UserTableMap)TM.user.create((int)2).age.values((Object)Integer.valueOf((int)23), (Object[])new Object[0])).user_name.values((Object)"tom mike", new Object[0]), new EqMode[0]);
    }

    @Test
    public void testInsert_NoAutoId() {
        db.table("no_auto_id").clean();
        this.idMapper.insert(new NoAutoIdEntity().setId("test-id-1").setColumn1("test"));
        this.idMapper.insert(new NoAutoIdEntity().setId("test-id-2").setColumn1("test"));
        db.table("no_auto_id").query().eqDataMap(TM.no_auto_id.create((int)2).id.values((Object)"test-id-1", new Object[]{"test-id-2"}), new EqMode[0]);
    }

    @Test
    public void testInsert_NoAutoId_conflict() {
        db.table("no_auto_id").clean().insert(new IDataMap[]{((NoAutoIdTableMap)TM.no_auto_id.createWithInit((int)1).id.values((Object)"test-id-1", (Object[])new Object[0])).column_1.values((Object)"test", new Object[0])});
        Assertions.assertThrows(DuplicateKeyException.class, () -> this.idMapper.insert(new NoAutoIdEntity().setId("test-id-1").setColumn1("test")));
    }

    @Test
    public void test_insert_noPrimary() {
        db.table("no_primary").clean();
        this.noPrimaryMapper.insert(new NoPrimaryEntity().setColumn1(23).setColumn2("test"));
        db.table("no_primary").query().eqDataMap(((NoPrimaryTableMap)TM.no_primary.create((int)1).column_1.values((Object)Integer.valueOf((int)23), (Object[])new Object[0])).column_2.values((Object)"test", new Object[0]), new EqMode[0]);
    }
}

