/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.test.method;

import cn.org.atool.fluent.mybatis.base.IQuery;
import cn.org.atool.fluent.mybatis.demo.generate.datamap.TM;
import cn.org.atool.fluent.mybatis.demo.generate.datamap.table.UserTableMap;
import cn.org.atool.fluent.mybatis.demo.generate.helper.UserWrapperHelper;
import cn.org.atool.fluent.mybatis.demo.generate.mapper.UserMapper;
import cn.org.atool.fluent.mybatis.demo.generate.wrapper.UserQuery;
import cn.org.atool.fluent.mybatis.segment.OrderByApply;
import cn.org.atool.fluent.mybatis.segment.WhereApply;
import cn.org.atool.fluent.mybatis.test.BaseTest;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.test4j.hamcrest.iassert.intf.IStringAssert;
import org.test4j.hamcrest.matcher.string.StringMode;
import org.test4j.tools.datagen.IDataMap;

public class CountNoLimitTest
extends BaseTest {
    @Autowired
    private UserMapper mapper;

    @Test
    public void test_count_no_limit() throws Exception {
        UserQuery query = (UserQuery)((UserQuery)((UserWrapperHelper.QueryOrderBy)((OrderByApply)((UserQuery)((UserWrapperHelper.QueryWhere)((WhereApply)new UserQuery().where.id()).eq((Object)Long.valueOf((long)24L))).end()).orderBy.userName()).asc()).end()).limit(10);
        this.mapper.count((IQuery)query);
        ((IStringAssert)db.sqlList().wantFirstSql().start("SELECT COUNT( * )", new StringMode[0])).end("FROM t_user WHERE id = ? ORDER BY user_name ASC LIMIT ?, ?", new StringMode[0]);
        this.mapper.countNoLimit((IQuery)query);
        db.sqlList().wantSql(1).end("WHERE id = ?", new StringMode[0]);
    }

    @Test
    public void test_count_and_list() throws Exception {
        db.table("t_user").clean().insert(new IDataMap[]{((UserTableMap)TM.user.createWithInit((int)100).age.values((Object)Integer.valueOf((int)10), (Object[])new Object[0])).user_name.values((Object)"u1", new Object[]{"u2", "u3", "u2"})});
        UserQuery query = (UserQuery)((UserQuery)((UserWrapperHelper.QueryOrderBy)((OrderByApply)((UserQuery)((UserWrapperHelper.QueryWhere)((WhereApply)new UserQuery().where.age()).eq((Object)Integer.valueOf((int)10))).end()).orderBy.userName()).asc()).end()).limit(10, 20);
        int count = this.mapper.countNoLimit((IQuery)query);
        ((IStringAssert)db.sqlList().wantFirstSql().start("SELECT COUNT( * )", new StringMode[0])).end("FROM t_user WHERE age = ?", new StringMode[0]);
        want.number(Integer.valueOf(count)).eq((Object)100);
        List list = this.mapper.listEntity((IQuery)query);
        ((IStringAssert)db.sqlList().wantSql(1).start("SELECT id,", new StringMode[0])).end("WHERE age = ? ORDER BY user_name ASC LIMIT ?, ?", new StringMode[0]);
        want.list((Collection)list).sizeEq(20);
    }
}

