/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.test.basedao.paged;

import cn.org.atool.fluent.mybatis.base.IDaoProtected;
import cn.org.atool.fluent.mybatis.base.IQuery;
import cn.org.atool.fluent.mybatis.base.model.PagedList;
import cn.org.atool.fluent.mybatis.demo.generate.datamap.TM;
import cn.org.atool.fluent.mybatis.demo.generate.datamap.table.UserTableMap;
import cn.org.atool.fluent.mybatis.demo.generate.helper.UserMapping;
import cn.org.atool.fluent.mybatis.demo.generate.helper.UserWrapperHelper;
import cn.org.atool.fluent.mybatis.demo.generate.wrapper.UserQuery;
import cn.org.atool.fluent.mybatis.segment.OrderByApply;
import cn.org.atool.fluent.mybatis.segment.WhereApply;
import cn.org.atool.fluent.mybatis.test.BaseTest;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.test4j.hamcrest.matcher.modes.EqMode;
import org.test4j.hamcrest.matcher.string.StringMode;
import org.test4j.tools.datagen.IDataMap;

public class SelectPagedListTest
extends BaseTest {
    @Autowired
    @Qualifier(value="userDaoImpl")
    private IDaoProtected daoProtected;

    @DisplayName(value="\u51c6\u5907100\u6761\u6570\u636e, \u5206\u9875\u67e5\u8be2\uff0c\u4e00\u6b21\u64cd\u4f5c\u8fd4\u56de\u603b\u6570\u548c\u7b26\u5408\u6761\u4ef6\u7684\u5217\u8868")
    @Test
    public void test_select_paged_list() throws Exception {
        db.table("t_user").clean().insert(new IDataMap[]{((UserTableMap)((UserTableMap)TM.user.createWithInit((int)100).id.autoIncrease()).user_name.formatAutoIncrease((String)"user_%d")).age.generate(index -> new Random().nextInt(100))});
        PagedList list = this.daoProtected.pagedEntity((IQuery)((UserQuery)((UserWrapperHelper.QueryOrderBy)((OrderByApply)((UserQuery)((UserWrapperHelper.QueryWhere)((WhereApply)new UserQuery().where.userName()).like((String)"user")).end()).orderBy.id()).asc()).end()).limit(20, 10));
        want.number(Integer.valueOf(list.getTotal())).eq((Object)100);
        List ids = list.getData().stream().map(e -> (int)e.getId().longValue()).collect(Collectors.toList());
        want.list(ids).eqReflect((Object)new int[]{21, 22, 23, 24, 25, 26, 27, 28, 29, 30}, new EqMode[0]);
        db.sqlList().wantSql(0).eq((Object)"SELECT COUNT( * ) FROM t_user WHERE user_name LIKE ?");
        db.sqlList().wantSql(1).end("FROM t_user WHERE user_name LIKE ? ORDER BY id ASC LIMIT ?, ?", new StringMode[0]);
    }

    @Test
    public void test_select_paged_list2() throws Exception {
        db.table("t_user").clean().insert(new IDataMap[]{((UserTableMap)((UserTableMap)TM.user.createWithInit((int)100).id.autoIncrease()).user_name.formatAutoIncrease((String)"user_%d")).age.generate(index -> new Random().nextInt(100))});
        Function<Map, Integer> convert = m -> ((BigInteger)m.get(UserMapping.id.column)).intValue();
        PagedList list = this.daoProtected.pagedMaps((IQuery)((UserQuery)((UserWrapperHelper.QueryOrderBy)((OrderByApply)((UserQuery)((UserWrapperHelper.QueryWhere)((WhereApply)((UserWrapperHelper.QueryWhere)((WhereApply)new UserQuery().where.id()).gt((Object)Integer.valueOf((int)20))).userName()).like((String)"user")).end()).orderBy.id()).asc()).end()).limit(10));
        want.number(Integer.valueOf(list.getTotal())).eq((Object)80);
        List ids = list.getData().stream().map(convert).collect(Collectors.toList());
        want.list(ids).eqReflect((Object)new int[]{21, 22, 23, 24, 25, 26, 27, 28, 29, 30}, new EqMode[0]);
    }
}

