/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.test.basedao;

import cn.org.atool.fluent.mybatis.demo.generate.datamap.TM;
import cn.org.atool.fluent.mybatis.demo.generate.datamap.table.UserTableMap;
import cn.org.atool.fluent.mybatis.demo.generate.entity.UserEntity;
import cn.org.atool.fluent.mybatis.demo.notgen.UserExtDao;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.test.BaseTest;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.test4j.function.SExecutor;
import org.test4j.hamcrest.matcher.modes.EqMode;
import org.test4j.hamcrest.matcher.string.StringMode;

public class SaveTest
extends BaseTest {
    @Autowired
    private UserExtDao dao;

    @Test
    public void test_save_noPk() throws Exception {
        db.table("t_user").clean();
        this.dao.save(new UserEntity().setUserName("test name").setAge(43));
        db.table("t_user").query().eqDataMap(((UserTableMap)TM.user.create((int)1).user_name.values((Object)"test name", (Object[])new Object[0])).age.values((Object)43, new Object[0]), new EqMode[0]);
    }

    @Test
    public void test_save_WithPk() throws Exception {
        db.table("t_user").clean();
        this.dao.save(new UserEntity().setId(4L).setUserName("test name").setAge(43));
        db.sqlList().wantFirstSql().contains(" id,", new StringMode[0]);
        db.table("t_user").query().eqDataMap(((UserTableMap)((UserTableMap)TM.user.create((int)1).id.values((Object)Integer.valueOf((int)4), (Object[])new Object[0])).user_name.values((Object)"test name", (Object[])new Object[0])).age.values((Object)43, new Object[0]), new EqMode[0]);
    }

    @Test
    public void test_batchSave_ErrorPk() throws Exception {
        db.table("t_user").clean();
        want.exception((SExecutor & Serializable)() -> this.dao.save(Arrays.asList(new UserEntity().setUserName("test name1").setAge(43), new UserEntity().setUserName("test name2").setAge(43).setId(5L))), new Class[]{FluentMybatisException.class}).eq((Object)"The primary key of the list instance must be assigned to all or none");
    }

    @Test
    public void test_batchSave_WithPk() throws Exception {
        db.table("t_user").clean();
        this.dao.save(Arrays.asList(new UserEntity().setId(4L).setUserName("test name1").setAge(43), new UserEntity().setId(5L).setUserName("test name2").setAge(43)));
        db.table("t_user").query().eqDataMap(((UserTableMap)((UserTableMap)TM.user.create((int)2).id.values((Object)Integer.valueOf((int)4), (Object[])new Object[]{Integer.valueOf((int)5)})).user_name.values((Object)"test name1", (Object[])new Object[]{"test name2"})).age.values((Object)43, new Object[0]), new EqMode[0]);
    }

    @Test
    public void test_batchSave_NoPk() throws Exception {
        db.table("t_user").clean();
        List list = this.list(new Object[]{new UserEntity().setUserName("test name1").setAge(43), new UserEntity().setUserName("test name2").setAge(43)});
        this.dao.save(list);
        db.table("t_user").query().eqDataMap(((UserTableMap)TM.user.create((int)2).user_name.values((Object)"test name1", (Object[])new Object[]{"test name2"})).age.values((Object)43, new Object[0]), new EqMode[0]);
        want.number(((UserEntity)list.get(0)).getId()).isNull();
        want.number(((UserEntity)list.get(1)).getId()).isNull();
    }
}

