/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.test.and;

import cn.org.atool.fluent.mybatis.base.IQuery;
import cn.org.atool.fluent.mybatis.demo.generate.helper.UserWrapperHelper;
import cn.org.atool.fluent.mybatis.demo.generate.mapper.UserMapper;
import cn.org.atool.fluent.mybatis.demo.generate.wrapper.UserQuery;
import cn.org.atool.fluent.mybatis.exception.FluentMybatisException;
import cn.org.atool.fluent.mybatis.segment.WhereApply;
import cn.org.atool.fluent.mybatis.test.BaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.test4j.hamcrest.matcher.modes.EqMode;
import org.test4j.hamcrest.matcher.string.StringMode;

public class WhereObjectTest_Eq
extends BaseTest {
    @Autowired
    private UserMapper mapper;

    @Test
    public void eq() {
        UserQuery query = (UserQuery)((UserWrapperHelper.QueryWhere)((WhereApply)new UserQuery().where.age()).eq((Object)34)).end();
        this.mapper.count((IQuery)query);
        db.sqlList().wantFirstSql().eq("SELECT COUNT( * ) FROM t_user WHERE age = ?", new StringMode[]{StringMode.SameAsSpace});
        db.sqlList().wantFirstPara().eqReflect((Object)new Object[]{34}, new EqMode[0]);
    }

    @Test
    public void eq_null() {
        Assertions.assertThrows(FluentMybatisException.class, () -> {
            UserWrapperHelper.QueryWhere cfr_ignored_0 = (UserWrapperHelper.QueryWhere)((WhereApply)new UserQuery().where.age()).eq(null);
        });
    }

    @Test
    public void eq_condition_true() {
        UserQuery query = (UserQuery)((UserWrapperHelper.QueryWhere)((WhereApply)new UserQuery().where.age()).eq(true, (Object)34)).end();
        this.mapper.count((IQuery)query);
        db.sqlList().wantFirstSql().eq("SELECT COUNT( * ) FROM t_user WHERE age = ?", new StringMode[]{StringMode.SameAsSpace});
        db.sqlList().wantFirstPara().eqReflect((Object)new Object[]{34}, new EqMode[0]);
    }

    @Test
    public void eq_condition_false() {
        UserQuery query = (UserQuery)((UserWrapperHelper.QueryWhere)((WhereApply)new UserQuery().where.age()).eq(false, (Object)34)).end();
        this.mapper.count((IQuery)query);
        db.sqlList().wantFirstSql().eq((Object)"SELECT COUNT( * ) FROM t_user");
        db.sqlList().wantFirstPara().sizeEq(0);
    }

    @Test
    public void eq_IfNotNull() {
        UserQuery query = (UserQuery)((UserWrapperHelper.QueryWhere)((WhereApply)new UserQuery().where.userName()).eq_IfNotNull((Object)"name")).end();
        this.mapper.count((IQuery)query);
        db.sqlList().wantFirstSql().eq("SELECT COUNT( * ) FROM t_user WHERE user_name = ?", new StringMode[]{StringMode.SameAsSpace});
        db.sqlList().wantFirstPara().eqReflect((Object)new Object[]{"name"}, new EqMode[0]);
    }

    @Test
    public void eq_IfNull() {
        UserQuery query = (UserQuery)((UserWrapperHelper.QueryWhere)((WhereApply)new UserQuery().where.userName()).eq_IfNotNull(null)).end();
        this.mapper.count((IQuery)query);
        db.sqlList().wantFirstSql().eq((Object)"SELECT COUNT( * ) FROM t_user");
        db.sqlList().wantFirstPara().sizeEq(0);
    }
}

