/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.generator.mock;

import cn.org.atool.fluent.mybatis.generator.MybatisGenerator;
import cn.org.atool.fluent.mybatis.generator.TableColumn;
import cn.org.atool.fluent.mybatis.generator.mock.CopyConfigBuilder;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mockit.Invocation;
import mockit.Mock;
import mockit.MockUp;
import org.apache.commons.lang3.StringUtils;

public class MockConfigBuilder
extends MockUp<CopyConfigBuilder> {
    @Mock
    public String processName2(Invocation it, String name, NamingStrategy strategy, String[] prefix) {
        if (prefix == null) {
            return this.processColumnName(it, name, strategy);
        }
        String _name = this.processTableName(it, name, strategy, prefix);
        String withSuffix = NamingStrategy.capitalFirst((String)_name);
        MybatisGenerator.currTable().setWithoutSuffixEntity(withSuffix);
        return _name;
    }

    @Mock
    public List<TableInfo> processTable2(Invocation it, List<TableInfo> tableList, NamingStrategy strategy, StrategyConfig config) {
        it.proceed(new Object[]{tableList, strategy, config});
        for (TableInfo tableInfo : tableList) {
            String string = MybatisGenerator.currTable().getWithoutSuffixEntity();
        }
        return tableList;
    }

    @Mock
    public TableInfo convertTableFields2(Invocation it, TableInfo tableInfo, StrategyConfig config) {
        TableInfo _tableInfo = (TableInfo)it.proceed(new Object[]{tableInfo, config});
        _tableInfo.setFields(_tableInfo.getFields().stream().filter(field -> MybatisGenerator.currTable().getColumn(field.getName()).map(TableColumn::isExclude).orElse(false) == false).collect(Collectors.toList()));
        this.sortFields(_tableInfo);
        return _tableInfo;
    }

    private void sortFields(TableInfo tableInfo) {
        List fields = tableInfo.getFields();
        ArrayList<TableField> sorts = new ArrayList<TableField>();
        TableField pkField = null;
        TableField gmtCreatedField = null;
        TableField gmtModifiedField = null;
        TableField isDeletedField = null;
        for (TableField field : fields) {
            if (field.isKeyIdentityFlag()) {
                pkField = field;
                continue;
            }
            if (field.getName().equals(MybatisGenerator.currTable().getGmtCreateColumn())) {
                gmtCreatedField = field;
                continue;
            }
            if (field.getName().equals(MybatisGenerator.currTable().getGmtModifiedColumn())) {
                gmtModifiedField = field;
                continue;
            }
            if (field.getName().equals(MybatisGenerator.currTable().getLogicDeletedColumn())) {
                isDeletedField = field;
                continue;
            }
            sorts.add(field);
        }
        Collections.sort(sorts, (field1, field2) -> field1.getName().compareTo(field2.getName()));
        fields.clear();
        if (pkField != null) {
            fields.add(pkField);
        }
        if (gmtCreatedField != null) {
            fields.add(gmtCreatedField);
        }
        if (gmtModifiedField != null) {
            fields.add(gmtModifiedField);
        }
        if (isDeletedField != null) {
            fields.add(isDeletedField);
        }
        fields.addAll(sorts);
        tableInfo.setFields(fields);
    }

    private String processColumnName(Invocation it, String name, NamingStrategy strategy) {
        String propertyName = MybatisGenerator.currTable().getPropertyNameByColumn(name);
        if (StringUtils.isNotBlank((CharSequence)propertyName)) {
            return propertyName;
        }
        return (String)it.proceed(new Object[]{name, strategy, null});
    }

    private String processTableName(Invocation it, String name, NamingStrategy strategy, String[] prefix) {
        if (StringUtils.isNotBlank((CharSequence)MybatisGenerator.currTable().getWithoutSuffixEntity())) {
            return MybatisGenerator.currTable().getWithoutSuffixEntity();
        }
        return (String)it.proceed(new Object[]{name, strategy, prefix});
    }
}

