/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.generator.mock;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.IDbQuery;
import com.baomidou.mybatisplus.generator.config.INameConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CopyConfigBuilder
extends ConfigBuilder {
    private final TemplateConfig template;
    private final DataSourceConfig dataSourceConfig;
    private Connection connection;
    private IDbQuery dbQuery;
    private String superEntityClass;
    private String superMapperClass;
    private String superServiceClass;
    private String superServiceImplClass;
    private String superControllerClass;
    private List<TableInfo> tableInfoList;
    private Map<String, String> packageInfo;
    private Map<String, String> pathInfo;
    private StrategyConfig strategyConfig;
    private GlobalConfig globalConfig;
    private InjectionConfig injectionConfig;
    private boolean commentSupported;

    public CopyConfigBuilder(PackageConfig packageConfig, DataSourceConfig dataSourceConfig, StrategyConfig strategyConfig, TemplateConfig template, GlobalConfig globalConfig) {
        super(packageConfig, dataSourceConfig, strategyConfig, template, globalConfig);
        this.globalConfig = null == globalConfig ? new GlobalConfig() : globalConfig;
        this.template = null == template ? new TemplateConfig() : template;
        if (null == packageConfig) {
            this.handlerPackage(this.template, this.globalConfig.getOutputDir(), new PackageConfig());
        } else {
            this.handlerPackage(this.template, this.globalConfig.getOutputDir(), packageConfig);
        }
        this.dataSourceConfig = dataSourceConfig;
        this.handlerDataSource(dataSourceConfig);
        this.strategyConfig = null == strategyConfig ? new StrategyConfig() : strategyConfig;
        this.commentSupported = !dataSourceConfig.getDbType().equals((Object)DbType.SQLITE);
        this.handlerStrategy(this.strategyConfig);
    }

    public Map<String, String> getPackageInfo() {
        return this.packageInfo;
    }

    public Map<String, String> getPathInfo() {
        return this.pathInfo;
    }

    public String getSuperEntityClass() {
        return this.superEntityClass;
    }

    public String getSuperMapperClass() {
        return this.superMapperClass;
    }

    public String getSuperServiceClass() {
        return this.superServiceClass;
    }

    public String getSuperServiceImplClass() {
        return this.superServiceImplClass;
    }

    public String getSuperControllerClass() {
        return this.superControllerClass;
    }

    public List<TableInfo> getTableInfoList() {
        return this.tableInfoList;
    }

    public ConfigBuilder setTableInfoList(List<TableInfo> tableInfoList) {
        this.tableInfoList = tableInfoList;
        return this;
    }

    public TemplateConfig getTemplate() {
        return this.template == null ? new TemplateConfig() : this.template;
    }

    void handlerPackage(TemplateConfig template, String outputDir, PackageConfig config) {
        this.packageInfo = new HashMap<String, String>(8);
        this.packageInfo.put("ModuleName", config.getModuleName());
        this.packageInfo.put("Entity", this.joinPackage(config.getParent(), config.getEntity()));
        this.packageInfo.put("Mapper", this.joinPackage(config.getParent(), config.getMapper()));
        this.packageInfo.put("Xml", this.joinPackage(config.getParent(), config.getXml()));
        this.packageInfo.put("Service", this.joinPackage(config.getParent(), config.getService()));
        this.packageInfo.put("ServiceImpl", this.joinPackage(config.getParent(), config.getServiceImpl()));
        this.packageInfo.put("Controller", this.joinPackage(config.getParent(), config.getController()));
        Map configPathInfo = config.getPathInfo();
        if (null != configPathInfo) {
            this.pathInfo = configPathInfo;
        } else {
            this.pathInfo = new HashMap<String, String>(6);
            this.setPathInfo(this.pathInfo, template.getEntity(this.getGlobalConfig().isKotlin()), outputDir, "entity_path", "Entity");
            this.setPathInfo(this.pathInfo, template.getMapper(), outputDir, "mapper_path", "Mapper");
            this.setPathInfo(this.pathInfo, template.getXml(), outputDir, "xml_path", "Xml");
            this.setPathInfo(this.pathInfo, template.getService(), outputDir, "service_path", "Service");
            this.setPathInfo(this.pathInfo, template.getServiceImpl(), outputDir, "service_impl_path", "ServiceImpl");
            this.setPathInfo(this.pathInfo, template.getController(), outputDir, "controller_path", "Controller");
        }
    }

    void setPathInfo(Map<String, String> pathInfo, String template, String outputDir, String path, String module) {
        if (StringUtils.isNotEmpty((CharSequence)template)) {
            pathInfo.put(path, this.joinPath(outputDir, this.packageInfo.get(module)));
        }
    }

    void handlerDataSource(DataSourceConfig config) {
        this.connection = config.getConn();
        this.dbQuery = config.getDbQuery();
    }

    void handlerStrategy(StrategyConfig config) {
        this.processTypes(config);
        this.tableInfoList = this.getTablesInfo(config);
    }

    void processTypes(StrategyConfig config) {
        this.superServiceClass = StringUtils.isEmpty((CharSequence)config.getSuperServiceClass()) ? "com.baomidou.mybatisplus.extension.service.IService" : config.getSuperServiceClass();
        this.superServiceImplClass = StringUtils.isEmpty((CharSequence)config.getSuperServiceImplClass()) ? "com.baomidou.mybatisplus.extension.service.impl.ServiceImpl" : config.getSuperServiceImplClass();
        this.superMapperClass = StringUtils.isEmpty((CharSequence)config.getSuperMapperClass()) ? "com.baomidou.mybatisplus.core.mapper.BaseMapper" : config.getSuperMapperClass();
        this.superEntityClass = config.getSuperEntityClass();
        this.superControllerClass = config.getSuperControllerClass();
    }

    List<TableInfo> processTable2(List<TableInfo> tableList, NamingStrategy strategy, StrategyConfig config) {
        String[] tablePrefix = config.getTablePrefix();
        for (TableInfo tableInfo : tableList) {
            INameConvert nameConvert = this.strategyConfig.getNameConvert();
            String entityName = null != nameConvert ? nameConvert.entityNameConvert(tableInfo) : NamingStrategy.capitalFirst((String)this.processName2(tableInfo.getName(), strategy, tablePrefix));
            if (StringUtils.isNotEmpty((CharSequence)this.globalConfig.getEntityName())) {
                tableInfo.setConvert(true);
                tableInfo.setEntityName(String.format(this.globalConfig.getEntityName(), entityName));
            } else {
                tableInfo.setEntityName(this.strategyConfig, entityName);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.globalConfig.getMapperName())) {
                tableInfo.setMapperName(String.format(this.globalConfig.getMapperName(), entityName));
            } else {
                tableInfo.setMapperName(entityName + "Mapper");
            }
            if (StringUtils.isNotEmpty((CharSequence)this.globalConfig.getXmlName())) {
                tableInfo.setXmlName(String.format(this.globalConfig.getXmlName(), entityName));
            } else {
                tableInfo.setXmlName(entityName + "Mapper");
            }
            if (StringUtils.isNotEmpty((CharSequence)this.globalConfig.getServiceName())) {
                tableInfo.setServiceName(String.format(this.globalConfig.getServiceName(), entityName));
            } else {
                tableInfo.setServiceName("I" + entityName + "Service");
            }
            if (StringUtils.isNotEmpty((CharSequence)this.globalConfig.getServiceImplName())) {
                tableInfo.setServiceImplName(String.format(this.globalConfig.getServiceImplName(), entityName));
            } else {
                tableInfo.setServiceImplName(entityName + "ServiceImpl");
            }
            if (StringUtils.isNotEmpty((CharSequence)this.globalConfig.getControllerName())) {
                tableInfo.setControllerName(String.format(this.globalConfig.getControllerName(), entityName));
            } else {
                tableInfo.setControllerName(entityName + "Controller");
            }
            this.checkImportPackages(tableInfo);
        }
        return tableList;
    }

    void checkImportPackages(TableInfo tableInfo) {
        if (StringUtils.isNotEmpty((CharSequence)this.strategyConfig.getSuperEntityClass())) {
            tableInfo.getImportPackages().add(this.strategyConfig.getSuperEntityClass());
        } else if (this.globalConfig.isActiveRecord()) {
            tableInfo.getImportPackages().add(Model.class.getCanonicalName());
        }
        if (null != this.globalConfig.getIdType()) {
            tableInfo.getImportPackages().add(IdType.class.getCanonicalName());
            tableInfo.getImportPackages().add(TableId.class.getCanonicalName());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.strategyConfig.getVersionFieldName())) {
            tableInfo.getFields().forEach(f -> {
                if (this.strategyConfig.getVersionFieldName().equals(f.getName())) {
                    tableInfo.getImportPackages().add(Version.class.getCanonicalName());
                }
            });
        }
    }

    List<TableInfo> getTablesInfo(StrategyConfig config) {
        boolean isExclude;
        boolean isInclude = null != config.getInclude() && config.getInclude().length > 0;
        boolean bl = isExclude = null != config.getExclude() && config.getExclude().length > 0;
        if (isInclude && isExclude) {
            throw new RuntimeException("<strategy> \u6807\u7b7e\u4e2d <include> \u4e0e <exclude> \u53ea\u80fd\u914d\u7f6e\u4e00\u9879\uff01");
        }
        ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
        ArrayList<Object> includeTableList = new ArrayList<TableInfo>();
        ArrayList<TableInfo> excludeTableList = new ArrayList<TableInfo>();
        HashSet<String> notExistTables = new HashSet<String>();
        try {
            String schema;
            String tablesSql = this.dbQuery.tablesSql();
            if (DbType.POSTGRE_SQL == this.dbQuery.dbType()) {
                schema = this.dataSourceConfig.getSchemaName();
                if (schema == null) {
                    schema = "public";
                    this.dataSourceConfig.setSchemaName(schema);
                }
                tablesSql = String.format(tablesSql, schema);
            }
            if (DbType.DB2 == this.dbQuery.dbType()) {
                schema = this.dataSourceConfig.getSchemaName();
                if (schema == null) {
                    schema = "current schema";
                    this.dataSourceConfig.setSchemaName(schema);
                }
                tablesSql = String.format(tablesSql, schema);
            } else if (DbType.ORACLE == this.dbQuery.dbType()) {
                StringBuilder sb;
                schema = this.dataSourceConfig.getSchemaName();
                if (schema == null) {
                    schema = this.dataSourceConfig.getUsername().toUpperCase();
                    this.dataSourceConfig.setSchemaName(schema);
                }
                tablesSql = String.format(tablesSql, schema);
                if (isInclude) {
                    sb = new StringBuilder(tablesSql);
                    sb.append(" AND ").append(this.dbQuery.tableName()).append(" IN (");
                    Arrays.stream(config.getInclude()).forEach(tbname -> sb.append("'").append(tbname.toUpperCase()).append("',"));
                    sb.replace(sb.length() - 1, sb.length(), ")");
                    tablesSql = sb.toString();
                } else if (isExclude) {
                    sb = new StringBuilder(tablesSql);
                    sb.append(" AND ").append(this.dbQuery.tableName()).append(" NOT IN (");
                    Arrays.stream(config.getExclude()).forEach(tbname -> sb.append("'").append(tbname.toUpperCase()).append("',"));
                    sb.replace(sb.length() - 1, sb.length(), ")");
                    tablesSql = sb.toString();
                }
            }
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(tablesSql);
                 ResultSet results = preparedStatement.executeQuery();){
                while (results.next()) {
                    String tableName = results.getString(this.dbQuery.tableName());
                    if (StringUtils.isNotEmpty((CharSequence)tableName)) {
                        TableInfo tableInfo = new TableInfo();
                        tableInfo.setName(tableName);
                        if (this.commentSupported) {
                            String tableComment = results.getString(this.dbQuery.tableComment());
                            if (config.isSkipView() && "VIEW".equals(tableComment)) continue;
                            tableInfo.setComment(tableComment);
                        }
                        if (isInclude) {
                            for (String includeTable : config.getInclude()) {
                                if (this.tableNameMatches(includeTable, tableName)) {
                                    includeTableList.add(tableInfo);
                                    continue;
                                }
                                notExistTables.add(includeTable);
                            }
                        } else if (isExclude) {
                            for (String excludeTable : config.getExclude()) {
                                if (this.tableNameMatches(excludeTable, tableName)) {
                                    excludeTableList.add(tableInfo);
                                    continue;
                                }
                                notExistTables.add(excludeTable);
                            }
                        }
                        tableList.add(tableInfo);
                        continue;
                    }
                    System.err.println("\u5f53\u524d\u6570\u636e\u5e93\u4e3a\u7a7a\uff01\uff01\uff01");
                }
            }
            for (TableInfo tabInfo : tableList) {
                notExistTables.remove(tabInfo.getName());
            }
            if (notExistTables.size() > 0) {
                System.err.println("\u8868 " + notExistTables + " \u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            }
            if (isExclude) {
                tableList.removeAll(excludeTableList);
                includeTableList = tableList;
            }
            if (!isInclude && !isExclude) {
                includeTableList = tableList;
            }
            includeTableList.forEach(ti -> this.convertTableFields2((TableInfo)ti, config));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.processTable2(includeTableList, config.getNaming(), config);
    }

    boolean tableNameMatches(String setTableName, String dbTableName) {
        return setTableName.equalsIgnoreCase(dbTableName) || StringUtils.matches((String)setTableName, (String)dbTableName);
    }

    TableInfo convertTableFields2(TableInfo tableInfo, StrategyConfig config) {
        boolean haveId = false;
        ArrayList<TableField> fieldList = new ArrayList<TableField>();
        ArrayList<TableField> commonFieldList = new ArrayList<TableField>();
        DbType dbType = this.dbQuery.dbType();
        String tableName = tableInfo.getName();
        try {
            Throwable throwable;
            Throwable throwable2;
            String tableFieldsSql = this.dbQuery.tableFieldsSql();
            HashSet<String> h2PkColumns = new HashSet<String>();
            if (DbType.POSTGRE_SQL == dbType) {
                tableFieldsSql = String.format(tableFieldsSql, this.dataSourceConfig.getSchemaName(), tableName);
            } else if (DbType.DB2 == dbType) {
                tableFieldsSql = String.format(tableFieldsSql, this.dataSourceConfig.getSchemaName(), tableName);
            } else if (DbType.ORACLE == dbType) {
                tableName = tableName.toUpperCase();
                tableFieldsSql = String.format(tableFieldsSql.replace("#schema", this.dataSourceConfig.getSchemaName()), tableName);
            } else if (DbType.DM == dbType) {
                tableName = tableName.toUpperCase();
                tableFieldsSql = String.format(tableFieldsSql, tableName);
            } else if (DbType.H2 == dbType) {
                tableName = tableName.toUpperCase();
                throwable2 = null;
                try (PreparedStatement pkQueryStmt = this.connection.prepareStatement(String.format("select * from INFORMATION_SCHEMA.INDEXES WHERE TABLE_NAME = '%s'", tableName));){
                    throwable = null;
                    try (ResultSet pkResults = pkQueryStmt.executeQuery();){
                        while (pkResults.next()) {
                            String primaryKey = pkResults.getString(this.dbQuery.fieldKey());
                            if (!Boolean.valueOf(primaryKey).booleanValue()) continue;
                            h2PkColumns.add(pkResults.getString(this.dbQuery.fieldName()));
                        }
                    }
                    catch (Throwable primaryKey) {
                        throwable = primaryKey;
                        throw primaryKey;
                    }
                }
                catch (Throwable pkResults) {
                    throwable2 = pkResults;
                    throw pkResults;
                }
                tableFieldsSql = String.format(tableFieldsSql, tableName);
            } else {
                tableFieldsSql = String.format(tableFieldsSql, tableName);
            }
            throwable2 = null;
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(tableFieldsSql);){
                throwable = null;
                try (ResultSet results = preparedStatement.executeQuery();){
                    while (results.next()) {
                        boolean isId;
                        TableField field = new TableField();
                        String columnName = results.getString(this.dbQuery.fieldName());
                        if (DbType.H2 == dbType) {
                            isId = h2PkColumns.contains(columnName);
                        } else {
                            String key = results.getString(this.dbQuery.fieldKey());
                            if (DbType.DB2 == dbType || DbType.SQLITE == dbType) {
                                isId = StringUtils.isNotEmpty((CharSequence)key) && "1".equals(key);
                            } else {
                                boolean bl = isId = StringUtils.isNotEmpty((CharSequence)key) && "PRI".equals(key.toUpperCase());
                            }
                        }
                        if (isId && !haveId) {
                            field.setKeyFlag(true);
                            if (DbType.H2 == dbType || DbType.SQLITE == dbType || this.dbQuery.isKeyIdentity(results)) {
                                field.setKeyIdentityFlag(true);
                            }
                            haveId = true;
                        } else {
                            field.setKeyFlag(false);
                        }
                        String[] fcs = this.dbQuery.fieldCustom();
                        if (null != fcs) {
                            HashMap<String, Object> customMap = new HashMap<String, Object>(fcs.length);
                            for (String fc : fcs) {
                                customMap.put(fc, results.getObject(fc));
                            }
                            field.setCustomMap(customMap);
                        }
                        field.setName(columnName);
                        field.setType(results.getString(this.dbQuery.fieldType()));
                        INameConvert nameConvert = this.strategyConfig.getNameConvert();
                        if (null != nameConvert) {
                            field.setPropertyName(nameConvert.propertyNameConvert(field));
                        } else {
                            field.setPropertyName(this.strategyConfig, this.processName2(field.getName(), config.getNaming()));
                        }
                        field.setColumnType(this.dataSourceConfig.getTypeConvert().processTypeConvert(this.globalConfig, field));
                        if (this.commentSupported) {
                            field.setComment(results.getString(this.dbQuery.fieldComment()));
                        }
                        if (this.strategyConfig.includeSuperEntityColumns(field.getName())) {
                            commonFieldList.add(field);
                            continue;
                        }
                        List tableFillList = this.getStrategyConfig().getTableFillList();
                        if (null != tableFillList) {
                            tableFillList.stream().filter(tf -> tf.getFieldName().equalsIgnoreCase(field.getName())).findFirst().ifPresent(tf -> field.setFill(tf.getFieldFill().name()));
                        }
                        fieldList.add(field);
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
        }
        catch (SQLException e) {
            System.err.println("SQL Exception\uff1a" + e.getMessage());
        }
        tableInfo.setFields(fieldList);
        tableInfo.setCommonFields(commonFieldList);
        return tableInfo;
    }

    String joinPath(String parentDir, String packageName) {
        if (StringUtils.isEmpty((CharSequence)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((String)parentDir, (String)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    String joinPackage(String parent, String subPackage) {
        if (StringUtils.isEmpty((CharSequence)parent)) {
            return subPackage;
        }
        return parent + "." + subPackage;
    }

    String processName2(String name, NamingStrategy strategy) {
        return this.processName2(name, strategy, this.strategyConfig.getFieldPrefix());
    }

    String processName2(String name, NamingStrategy strategy, String[] prefix) {
        boolean removePrefix = false;
        if (prefix != null && prefix.length != 0) {
            removePrefix = true;
        }
        String propertyName = removePrefix ? (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.removePrefixAndCamel((String)name, (String[])prefix) : NamingStrategy.removePrefix((String)name, (String[])prefix)) : (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.underlineToCamel((String)name) : name);
        return propertyName;
    }
}

